"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGradientStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireWildcard(require("react"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/components/entity_highlights_gradients.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO: Remove Gradient constants when EUI supports AI gradients (borders, icons, etc.)
// see https://github.com/elastic/kibana-team/issues/2398

// Shared gradient variables
const gradientStartPercent = 2.98;
const gradientEndPercent = 66.24;
const panelBackgroundGradientAngle = 99;
const panelBackgroundGradientStartPercent = 3.97;
const panelBackgroundGradientEndPercent = 65.6;
const panelBorderAndButtonGradientAngle = 131;
const lightModeColors = {
  panelBackgroundGradient: `linear-gradient(${panelBackgroundGradientAngle}deg, rgba(217, 232, 255, 0.25) ${panelBackgroundGradientStartPercent}%, rgba(236, 226, 254, 0.25) ${panelBackgroundGradientEndPercent}%)`,
  panelBorderGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, rgba(23, 80, 186, 0.35) ${gradientStartPercent}%, rgba(115, 29, 207, 0.35) ${gradientEndPercent}%)`,
  buttonGradient: `linear-gradient(99deg, #D9E8FF 3.97%, #ECE2FE 65.6%)`,
  buttonTextGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, #1750ba ${gradientStartPercent}%, #8144cc ${gradientEndPercent}%)`,
  iconGradientStartColor: '#0B64DD',
  iconGradientEndColor: '#731DCF'
};
const darkModeColors = {
  // TODO: AI generated gradients, please replace it with UX designed gradients when they are available. https://github.com/elastic/security-team/issues/15312
  panelBackgroundGradient: `linear-gradient(${panelBackgroundGradientAngle}deg, rgba(11, 100, 221, 0.14) ${panelBackgroundGradientStartPercent}%, rgba(115, 29, 207, 0.14) ${panelBackgroundGradientEndPercent}%)`,
  panelBorderGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, rgba(96, 165, 250, 0.4) ${gradientStartPercent}%, rgba(192, 132, 252, 0.4) ${gradientEndPercent}%)`,
  buttonGradient: `linear-gradient(${panelBackgroundGradientAngle}deg, #123A79 ${panelBackgroundGradientStartPercent}%, #3B1D66 ${panelBackgroundGradientEndPercent}%)`,
  buttonTextGradient: `linear-gradient(${panelBorderAndButtonGradientAngle}deg, #D9E8FF ${gradientStartPercent}%, #ECE2FE ${gradientEndPercent}%)`,
  iconGradientStartColor: '#60A5FA',
  iconGradientEndColor: '#C084FC'
};
const useGradientStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return (0, _react2.useMemo)(() => {
    const colors = isDarkMode ? darkModeColors : lightModeColors;
    return {
      gradientSVG: /*#__PURE__*/_react2.default.createElement("svg", {
        width: "0",
        height: "0",
        style: {
          position: 'absolute'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement("defs", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement("linearGradient", {
        id: "entity-summary-icon-gradient",
        x1: "0%",
        y1: "0%",
        x2: "100%",
        y2: "100%",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement("stop", {
        offset: `${gradientStartPercent}%`,
        stopColor: colors.iconGradientStartColor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react2.default.createElement("stop", {
        offset: `${gradientEndPercent}%`,
        stopColor: colors.iconGradientEndColor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 15
        }
      })))),
      gradientPanelStyle: (0, _react.css)`
        position: relative;
        background: ${colors.panelBackgroundGradient};
        border-radius: ${euiTheme.border.radius.medium};
        padding: ${euiTheme.size.base};
        &::before {
          content: '';
          position: absolute;
          inset: 0;
          padding: 1px;
          background: ${colors.panelBorderGradient};
          border-radius: ${euiTheme.border.radius.medium};
          mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
          mask-composite: exclude;
          -webkit-mask-composite: xor;
          pointer-events: none;
        }
      `,
      buttonGradientStyle: (0, _react.css)`
        background: ${colors.buttonGradient} !important;
        border-radius: 4px;

        &:hover:not(:disabled) {
          background: ${colors.buttonGradient} !important;
        }
        &:focus:not(:disabled) {
          background: ${colors.buttonGradient} !important;
        }
        &:disabled {
          opacity: 0.5;
        }
      `,
      buttonTextGradientStyle: (0, _react.css)`
        background: ${colors.buttonTextGradient};
        background-clip: text;
        color: transparent;
      `,
      iconGradientStyle: (0, _react.css)`
        & * {
          fill: url(#entity-summary-icon-gradient) !important;
        }
      `
    };
  }, [euiTheme, isDarkMode]);
};
exports.useGradientStyles = useGradientStyles;