"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityHighlightsAccordion = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _use_stored_state = require("../../../../onboarding/components/hooks/use_stored_state");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_has_entity_highlights_license = require("../../../../common/hooks/use_has_entity_highlights_license");
var _use_fetch_entity_details_highlights = require("../hooks/use_fetch_entity_details_highlights");
var _entity_highlights_settings = require("./entity_highlights_settings");
var _entity_highlights_result = require("./entity_highlights_result");
var _entity_highlights_gradients = require("./entity_highlights_gradients");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/components/entity_highlights.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityHighlightsAccordion = ({
  entityType,
  entityIdentifier
}) => {
  var _ref, _anonymizationFields$, _assistantResult$gene;
  const {
    data: anonymizationFields,
    isLoading: isAnonymizationFieldsLoading
  } = (0, _elasticAssistant.useFetchAnonymizationFields)();
  const {
    http,
    settings
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    settings
  });
  const firstConnector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors[0];
  const spaceId = (0, _use_space_id.useSpaceId)();
  const [selectedConnectorId, setConnectorId] = (0, _use_stored_state.useStoredAssistantConnectorId)(spaceId !== null && spaceId !== void 0 ? spaceId : '');
  const connectorId = (_ref = selectedConnectorId !== null && selectedConnectorId !== void 0 ? selectedConnectorId : firstConnector === null || firstConnector === void 0 ? void 0 : firstConnector.id) !== null && _ref !== void 0 ? _ref : '';
  const connectorName = (0, _react.useMemo)(() => {
    var _aiConnectors$find$na, _aiConnectors$find;
    if (!aiConnectors || !connectorId) return '';
    return (_aiConnectors$find$na = (_aiConnectors$find = aiConnectors.find(c => c.id === connectorId)) === null || _aiConnectors$find === void 0 ? void 0 : _aiConnectors$find.name) !== null && _aiConnectors$find$na !== void 0 ? _aiConnectors$find$na : '';
  }, [aiConnectors, connectorId]);
  const {
    hasAssistantPrivilege,
    isAssistantEnabled,
    isAssistantVisible
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const hasEntityHighlightsLicense = (0, _use_has_entity_highlights_license.useHasEntityHighlightsLicense)();
  const {
    gradientPanelStyle,
    buttonGradientStyle,
    iconGradientStyle,
    gradientSVG,
    buttonTextGradientStyle
  } = (0, _entity_highlights_gradients.useGradientStyles)();
  const [showAnonymizedValues, setShowAnonymizedValues] = (0, _react.useState)(false);
  const onChangeShowAnonymizedValues = (0, _react.useCallback)(e => {
    setShowAnonymizedValues(e.target.checked);
  }, [setShowAnonymizedValues]);
  const {
    fetchEntityHighlights,
    isChatLoading,
    result: assistantResult,
    error
  } = (0, _use_fetch_entity_details_highlights.useFetchEntityDetailsHighlights)({
    connectorId,
    anonymizationFields: (_anonymizationFields$ = anonymizationFields === null || anonymizationFields === void 0 ? void 0 : anonymizationFields.data) !== null && _anonymizationFields$ !== void 0 ? _anonymizationFields$ : [],
    entityType,
    entityIdentifier
  });
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const disabled = (0, _react.useMemo)(() => !hasAssistantPrivilege || !isAssistantEnabled || !hasEntityHighlightsLicense, [hasAssistantPrivilege, isAssistantEnabled, hasEntityHighlightsLicense]);
  const isLoading = (0, _react.useMemo)(() => isChatLoading || isAnonymizationFieldsLoading, [isAnonymizationFieldsLoading, isChatLoading]);
  const [dismissedError, setDismissedError] = (0, _react.useState)(null);
  const showErrorBanner = (0, _react.useMemo)(() => error != null && error !== dismissedError, [dismissedError, error]);
  if (disabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, gradientSVG, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    id: "entity-highlights",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.highlights.title",
      defaultMessage: "Entity summary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sparkles",
      css: iconGradientStyle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    }))),
    "data-test-subj": "asset-criticality-selector",
    extraAction: /*#__PURE__*/_react.default.createElement(_entity_highlights_settings.EntityHighlightsSettings, {
      assistantResult: assistantResult,
      showAnonymizedValues: showAnonymizedValues,
      onChangeShowAnonymizedValues: onChangeShowAnonymizedValues,
      setConnectorId: setConnectorId,
      connectorId: connectorId,
      connectorName: connectorName,
      closePopover: closePopover,
      openPopover: onButtonClick,
      isLoading: isLoading,
      isPopoverOpen: isPopoverOpen,
      isAssistantVisible: isAssistantVisible,
      entityType: entityType,
      entityIdentifier: entityIdentifier,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), showErrorBanner && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": "entity-highlights-error-banner",
    announceOnMount: true,
    size: "s",
    heading: "p",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.highlights.errorBannerTitle",
      defaultMessage: "Error generating summary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 17
      }
    }),
    onDismiss: () => setDismissedError(error),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.errorBannerBody",
    defaultMessage: "Due to an unexpected issue, LLM could not generate the summary. Please try again.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "refresh",
    onClick: fetchEntityHighlights,
    isDisabled: !connectorId || isLoading,
    "data-test-subj": "entity-highlights-error-regenerate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.errorBannerRegenerate",
    defaultMessage: "Regenerate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  })), assistantResult && !isLoading && /*#__PURE__*/_react.default.createElement(_entity_highlights_result.EntityHighlightsResult, {
    assistantResult: assistantResult,
    showAnonymizedValues: showAnonymizedValues,
    generatedAt: (_assistantResult$gene = assistantResult === null || assistantResult === void 0 ? void 0 : assistantResult.generatedAt) !== null && _assistantResult$gene !== void 0 ? _assistantResult$gene : null,
    onRefresh: fetchEntityHighlights,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }), isChatLoading && /*#__PURE__*/_react.default.createElement("div", {
    css: gradientPanelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.loadingMessage",
    defaultMessage: "Generating AI summary and recommended actions...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  })), !assistantResult && !isLoading && !showErrorBanner && /*#__PURE__*/_react.default.createElement("div", {
    css: gradientPanelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 17
    }
  }, !connectorId ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.cardDescription.noConnector",
    defaultMessage: "No AI connector is configured. Please configure an AI connector to generate a summary.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.cardDescription.default",
    defaultMessage: "Create AI summary of the entity to better understand its key characteristics and see recommended actions.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 21
    }
  }))), connectorId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: fetchEntityHighlights,
    isDisabled: !connectorId,
    css: buttonGradientStyle,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: buttonTextGradientStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.highlights.generateButton",
    defaultMessage: "Generate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 23
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }));
};
exports.EntityHighlightsAccordion = EntityHighlightsAccordion;