"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../../../overview/components/detection_response/utils");
var _links = require("../../../common/components/links");
var _search_strategy = require("../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _redirect_to_hosts = require("../../../common/components/link_to/redirect_to_hosts");
var _types = require("../../../app/types");
var _model = require("../../../explore/hosts/store/model");
var _store = require("../../../explore/hosts/store");
var _store2 = require("../../../explore/users/store");
var _redirect_to_users = require("../../../common/components/link_to/redirect_to_users");
var _model2 = require("../../../explore/users/store/model");
var _use_anomalies_search = require("../../../common/components/ml/anomaly/use_anomalies_search");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _manage_query = require("../../../common/components/page/manage_query");
var _entity_analytics_anomalies = require("../entity_analytics_anomalies");
var _helpers = require("../../../../common/machine_learning/helpers");
var _formatted_number = require("../../../common/components/formatted_number");
var _use_global_filter_query = require("../../../common/hooks/use_global_filter_query");
var _use_risk_score_kpi = require("../../api/hooks/use_risk_score_kpi");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_header/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiTitle = (0, _styled.default)(_eui.EuiTitle)`
  color: ${_utils.SEVERITY_COLOR.critical};
`;

// This is not used by the inspect feature but required by the refresh button
const HOST_RISK_QUERY_ID = 'hostRiskScoreKpiQuery';
const USER_RISK_QUERY_ID = 'userRiskScoreKpiQuery';
const EntityAnalyticsHeader = () => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    severityCount: hostsSeverityCount,
    loading: hostRiskLoading,
    inspect: inspectHostRiskScore,
    refetch: refetchHostRiskScore
  } = (0, _use_risk_score_kpi.useRiskScoreKpi)({
    timerange,
    riskEntity: _search_strategy.EntityType.host,
    filterQuery
  });
  const {
    severityCount: usersSeverityCount,
    loading: userRiskLoading,
    refetch: refetchUserRiskScore,
    inspect: inspectUserRiskScore
  } = (0, _use_risk_score_kpi.useRiskScoreKpi)({
    filterQuery,
    timerange,
    riskEntity: _search_strategy.EntityType.user
  });
  const {
    data
  } = (0, _use_anomalies_search.useAggregatedAnomaliesByJob)({
    skip: false,
    from,
    to
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const [goToHostRiskTabFilteredByCritical, hostRiskTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps({
      deepLinkId: _types.SecurityPageName.hosts,
      path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.risk),
      onClick: () => {
        dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
          severitySelection: [_search_strategy.RiskSeverity.Critical],
          hostsType: _model.HostsType.page
        }));
        dispatch(_store.hostsActions.updateHostRiskScoreSort({
          sort: {
            field: _search_strategy.RiskScoreFields.hostRiskScore,
            direction: _search_strategy.Direction.desc
          },
          hostsType: _model.HostsType.page
        }));
      }
    });
    return [onClick, href];
  }, [dispatch, getSecuritySolutionLinkProps]);
  const [goToUserRiskTabFilteredByCritical, userRiskTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps({
      deepLinkId: _types.SecurityPageName.users,
      path: (0, _redirect_to_users.getTabsOnUsersUrl)(_model2.UsersTableType.risk),
      onClick: () => {
        dispatch(_store2.usersActions.updateUserRiskScoreSeverityFilter({
          severitySelection: [_search_strategy.RiskSeverity.Critical]
        }));
        dispatch(_store2.usersActions.updateTableSorting({
          sort: {
            field: _search_strategy.RiskScoreFields.userRiskScore,
            direction: _search_strategy.Direction.desc
          },
          tableType: _model2.UsersTableType.risk
        }));
      }
    });
    return [onClick, href];
  }, [dispatch, getSecuritySolutionLinkProps]);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  (0, _manage_query.useQueryInspector)({
    queryId: USER_RISK_QUERY_ID,
    loading: userRiskLoading,
    refetch: refetchUserRiskScore,
    setQuery,
    deleteQuery,
    inspect: inspectUserRiskScore
  });
  (0, _manage_query.useQueryInspector)({
    queryId: HOST_RISK_QUERY_ID,
    loading: hostRiskLoading,
    refetch: refetchHostRiskScore,
    setQuery,
    deleteQuery,
    inspect: inspectHostRiskScore
  });

  // Anomaly jobs are enabled if at least one job is started or has data
  const areJobsEnabled = (0, _react.useMemo)(() => data.some(({
    job,
    count
  }) => count > 0 || job && (0, _helpers.isJobStarted)(job.jobState, job.datafeedState)), [data]);
  const totalAnomalies = (0, _react.useMemo)(() => areJobsEnabled ? /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: (0, _fp.sumBy)('count', data),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 29
    }
  }) : '-', [data, areJobsEnabled]);
  const scrollToAnomalies = (0, _react.useCallback)(() => {
    const element = document.querySelector(`[data-test-subj="${_entity_analytics_anomalies.ENTITY_ANALYTICS_ANOMALIES_PANEL}"]`);
    if (element) {
      element.scrollIntoView({
        behavior: 'smooth'
      });
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, isPlatinumOrTrialLicense && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CriticalEntitiesCount, {
    entityType: _search_strategy.EntityType.host,
    severityCount: hostsSeverityCount,
    onClick: goToHostRiskTabFilteredByCritical,
    href: hostRiskTabUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CriticalEntitiesCount, {
    entityType: _search_strategy.EntityType.user,
    severityCount: usersSeverityCount,
    onClick: goToUserRiskTabFilteredByCritical,
    href: userRiskTabUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "anomalies_quantity",
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 19
    }
  }, totalAnomalies))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "all_anomalies_link",
    onClick: scrollToAnomalies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, i18n.ANOMALIES))))));
};
exports.EntityAnalyticsHeader = EntityAnalyticsHeader;
const CriticalEntitiesCount = ({
  entityType,
  severityCount,
  href,
  onClick
}) => {
  const CriticalEntitiesText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.header.criticalEntities",
    defaultMessage: "Critical {entityType}",
    values: {
      entityType: (0, _fp.capitalize)(entityType)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiTitle, {
    "data-test-subj": `critical_${entityType}s_quantity`,
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  }, severityCount ? /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: severityCount[_search_strategy.RiskSeverity.Critical],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 30
    }
  }) : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }, href || onClick ? /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: onClick,
    href: href,
    "data-test-subj": `critical_${entityType}s_link`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, CriticalEntitiesText) : CriticalEntitiesText));
};