"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENABLE_RISK_SCORE_POPOVER = exports.ENABLE_RISK_SCORE_DESCRIPTION = exports.ENABLE_RISK_SCORE = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../risk_score/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENABLE_RISK_SCORE_POPOVER = exports.ENABLE_RISK_SCORE_POPOVER = _i18n.i18n.translate('xpack.securitySolution.enableRiskScore.enableRiskScorePopoverTitle', {
  defaultMessage: 'Alerts need to be available before enabling module'
});
const ENABLE_RISK_SCORE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.enableRiskScore.enableRiskScore', {
  defaultMessage: 'Enable {riskEntity} Risk Score',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.ENABLE_RISK_SCORE = ENABLE_RISK_SCORE;
const ENABLE_RISK_SCORE_DESCRIPTION = riskEntity => _i18n.i18n.translate('xpack.securitySolution.enableRiskScore.enableRiskScoreDescription', {
  defaultMessage: 'Once you have enabled this feature you can get quick access to the {riskEntity} risk scores in this section. The data might need an hour to be generated after enabling the module.',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.ENABLE_RISK_SCORE_DESCRIPTION = ENABLE_RISK_SCORE_DESCRIPTION;