"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUPPRESSED_ALERT_TOOLTIP = exports.DEFAULT_TABLE_DATE_COLUMN_MIN_WIDTH = exports.DEFAULT_TABLE_COLUMN_MIN_WIDTH = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPRESSED_ALERT_TOOLTIP = numAlertsSuppressed => _i18n.i18n.translate('xpack.securitySolution.configurations.suppressedAlerts', {
  defaultMessage: 'Alert has {numAlertsSuppressed} suppressed alerts',
  values: {
    numAlertsSuppressed
  }
});

/** The default minimum width of a column (when a width for the column type is not specified) */
exports.SUPPRESSED_ALERT_TOOLTIP = SUPPRESSED_ALERT_TOOLTIP;
const DEFAULT_TABLE_COLUMN_MIN_WIDTH = exports.DEFAULT_TABLE_COLUMN_MIN_WIDTH = 180; // px

/** The default minimum width of a column of type `date` */
const DEFAULT_TABLE_DATE_COLUMN_MIN_WIDTH = exports.DEFAULT_TABLE_DATE_COLUMN_MIN_WIDTH = 190; // px