"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../../common/lib/kibana");
var _osquery_flyout_footer = require("./osquery_flyout_footer");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/osquery/osquery_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OsqueryActionWrapper = _styledComponents.default.div`
  padding: 8px;
`;
// Make sure we keep this and ACTIONS_QUERY_KEY in use_all_live_queries.ts in sync.
const ACTIONS_QUERY_KEY = 'actions';
const OsqueryFlyoutComponent = ({
  agentId,
  defaultValues,
  onClose,
  ecsData
}) => {
  const {
    services: {
      osquery
    }
  } = (0, _kibana.useKibana)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const invalidateQueries = (0, _react.useCallback)(() => {
    var _defaultValues$alertI;
    queryClient.invalidateQueries({
      queryKey: [ACTIONS_QUERY_KEY, {
        alertId: defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$alertI = defaultValues.alertIds) === null || _defaultValues$alertI === void 0 ? void 0 : _defaultValues$alertI[0]
      }]
    });
  }, [defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.alertIds, queryClient]);
  const osqueryFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'osqueryFlyoutTitle'
  });
  if (osquery !== null && osquery !== void 0 && osquery.OsqueryAction) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      size: "m",
      onClose: onClose,
      "aria-labelledby": osqueryFlyoutTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      "data-test-subj": "flyout-header-osquery",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: osqueryFlyoutTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, _translations.ACTION_OSQUERY))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(OsqueryActionWrapper, {
      "data-test-subj": "flyout-body-osquery",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(osquery.OsqueryAction, {
      agentId: agentId,
      formType: "steps",
      defaultValues: defaultValues,
      ecsData: ecsData,
      onSuccess: invalidateQueries,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_osquery_flyout_footer.OsqueryEventDetailsFooter, {
      handleClick: onClose,
      "data-test-subj": "flyout-footer-osquery",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    })));
  }
  return null;
};
const OsqueryFlyout = exports.OsqueryFlyout = /*#__PURE__*/_react.default.memo(OsqueryFlyoutComponent);