"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = exports.CONTENT_TEST_ID = exports.AttacksPageContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _lodash = require("lodash");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _kibana = require("../../../common/lib/kibana");
var _use_find_attack_discoveries = require("../../../attack_discovery/pages/use_find_attack_discoveries");
var _use_selector = require("../../../common/hooks/use_selector");
var _schedule = require("../../../attack_discovery/pages/header/schedule");
var _filter_by_assignees_popover = require("../../../common/components/filter_by_assignees_popover/filter_by_assignees_popover");
var _translations = require("../../pages/attacks/translations");
var _header_page = require("../../../common/components/header_page");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _display = require("../../../explore/hosts/pages/display");
var _search_bar_section = require("./search_bar/search_bar_section");
var _schedule_flyout = require("./schedule_flyout");
var _table_section = require("./table/table_section");
var _connector_filter = require("../../../attack_discovery/pages/results/history/search_and_filter/connector_filter");
var _filters_section = require("./filters/filters_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/attacks/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'attacks-page-content';
const SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = exports.SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = 'attacks-page-security-solution-page-wrapper';

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
/**
 * Renders the content of the attacks page: search bar, header, filters, KPIs, and table sections.
 */
const AttacksPageContent = exports.AttacksPageContent = /*#__PURE__*/_react.default.memo(({
  dataView
}) => {
  const containerElement = (0, _react.useRef)(null);
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const [selectedConnectorNames, setSelectedConnectorNames] = (0, _react.useState)([]);
  const {
    services: {
      settings
    }
  } = (0, _kibana.useKibana)();
  const {
    http,
    inferenceEnabled
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    inferenceEnabled,
    settings
  });
  const {
    data
  } = (0, _use_find_attack_discoveries.useFindAttackDiscoveries)({
    http,
    isAssistantEnabled: true
  });
  const aiConnectorNames = (0, _react.useMemo)(() => {
    var _data$connector_names;
    return (_data$connector_names = data === null || data === void 0 ? void 0 : data.connector_names) !== null && _data$connector_names !== void 0 ? _data$connector_names : [];
  }, [data]);

  // showing / hiding the flyout:
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const openFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(true);
  }, []);
  const onClose = (0, _react.useCallback)(() => setShowFlyout(false), []);
  const [assignees, setAssignees] = (0, _react.useState)([]);
  const onAssigneesSelectionChange = (0, _react.useCallback)(newAssignees => {
    if (!(0, _lodash.isEqual)(newAssignees, assignees)) {
      setAssignees(newAssignees);
    }
  }, [assignees]);
  const [statusFilter, setStatusFilter] = (0, _react.useState)([]);
  const [pageFilters, setPageFilters] = (0, _react.useState)();
  const [pageFilterHandler, setPageFilterHandler] = (0, _react.useState)();
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const isTableLoading = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.alertsOnAlertsPage)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).isLoading;
  });
  (0, _react.useEffect)(() => {
    if (!pageFilterHandler) return;
    // if the table is reloaded because of action by the user
    // (e.g. closed and alert)
    // We want reload the values in the Attacks Page filters
    if (!isTableLoading) pageFilterHandler.reload();
  }, [isTableLoading, pageFilterHandler]);
  return /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    "data-test-subj": CONTENT_TEST_ID,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_search_bar_section.SearchBarSection, {
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    "data-test-subj": SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_by_assignees_popover.FilterByAssigneesPopover, {
    selectedUserIds: assignees,
    onSelectionChange: onAssigneesSelectionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_filter.ConnectorFilter, {
    aiConnectors: aiConnectors,
    connectorNames: aiConnectorNames,
    selectedConnectorNames: selectedConnectorNames,
    setSelectedConnectorNames: setSelectedConnectorNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_schedule.Schedule, {
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_section.FiltersSection, {
    dataView: dataView,
    setStatusFilter: setStatusFilter,
    setPageFilters: setPageFilters,
    setPageFilterHandler: setPageFilterHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_table_section.TableSection, {
    dataView: dataView,
    statusFilter: statusFilter,
    pageFilters: pageFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }), showFlyout && /*#__PURE__*/_react.default.createElement(_schedule_flyout.SchedulesFlyout, {
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 24
    }
  })));
});
AttacksPageContent.displayName = 'AttacksPageContent';