"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertAssigneesActions = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/components/assignees/constants");
var _use_bulk_alert_assignees_items = require("../../../../common/components/toolbar/bulk_actions/use_bulk_alert_assignees_items");
var _use_alerts_privileges = require("../../../containers/detection_engine/alerts/use_alerts_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertAssigneesActions = ({
  closePopover,
  ecsRowData,
  refetch
}) => {
  var _ecsRowData$kibana2;
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const alertId = ecsRowData._id;
  const alertAssignments = (0, _react.useMemo)(() => {
    var _ecsRowData$kibana$al, _ecsRowData$kibana;
    return (_ecsRowData$kibana$al = ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana = ecsRowData.kibana) === null || _ecsRowData$kibana === void 0 ? void 0 : _ecsRowData$kibana.alert.workflow_assignee_ids) !== null && _ecsRowData$kibana$al !== void 0 ? _ecsRowData$kibana$al : [];
  }, [ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana2 = ecsRowData.kibana) === null || _ecsRowData$kibana2 === void 0 ? void 0 : _ecsRowData$kibana2.alert.workflow_assignee_ids]);
  const alertAssigneeData = (0, _react.useMemo)(() => {
    var _ecsRowData$_index, _ecsRowData$_index2;
    return [{
      _id: alertId,
      _index: (_ecsRowData$_index = ecsRowData._index) !== null && _ecsRowData$_index !== void 0 ? _ecsRowData$_index : '',
      data: [{
        field: _ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS,
        value: alertAssignments
      }],
      ecs: {
        _id: alertId,
        _index: (_ecsRowData$_index2 = ecsRowData._index) !== null && _ecsRowData$_index2 !== void 0 ? _ecsRowData$_index2 : ''
      }
    }];
  }, [alertId, ecsRowData._index, alertAssignments]);
  const onAssigneesUpdate = (0, _react.useCallback)(() => {
    closePopover();
    if (refetch) {
      refetch();
    }
  }, [closePopover, refetch]);
  const {
    alertAssigneesItems,
    alertAssigneesPanels
  } = (0, _use_bulk_alert_assignees_items.useBulkAlertAssigneesItems)({
    onAssigneesUpdate,
    alertAssignments
  });
  const itemsToReturn = (0, _react.useMemo)(() => alertAssigneesItems.map(item => ({
    name: item.name,
    panel: item.panel,
    'data-test-subj': item['data-test-subj'],
    key: item.key,
    onClick: () => {
      var _item$onClick;
      return (_item$onClick = item.onClick) === null || _item$onClick === void 0 ? void 0 : _item$onClick.call(item, alertAssigneeData, false, _lodash.noop, _lodash.noop, _lodash.noop);
    },
    disabled: item.disable
  })), [alertAssigneeData, alertAssigneesItems]);
  const panelsToReturn = (0, _react.useMemo)(() => alertAssigneesPanels.map(panel => {
    const content = panel.renderContent({
      closePopoverMenu: closePopover,
      setIsBulkActionsLoading: () => {},
      alertItems: alertAssigneeData,
      refresh: onAssigneesUpdate
    });
    return {
      title: panel.title,
      content,
      id: panel.id,
      width: _constants.ASSIGNEES_PANEL_WIDTH
    };
  }), [alertAssigneeData, alertAssigneesPanels, closePopover, onAssigneesUpdate]);
  return {
    alertAssigneesItems: hasIndexWrite ? itemsToReturn : [],
    alertAssigneesPanels: panelsToReturn
  };
};
exports.useAlertAssigneesActions = useAlertAssigneesActions;