"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToCaseActions = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("../../../../../common");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddToCaseActions = ({
  onMenuItemClick,
  ariaLabel,
  ecsData,
  nonEcsData,
  onSuccess,
  refetch
}) => {
  const {
    cases: casesUi
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = casesUi.helpers.canUseCases([_common2.APP_ID]);
  const isAlert = (0, _react.useMemo)(() => {
    var _ecsData$event, _ecsData$event$kind;
    return ecsData === null || ecsData === void 0 ? void 0 : (_ecsData$event = ecsData.event) === null || _ecsData$event === void 0 ? void 0 : (_ecsData$event$kind = _ecsData$event.kind) === null || _ecsData$event$kind === void 0 ? void 0 : _ecsData$event$kind.includes('signal');
  }, [ecsData]);
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_id2, _ecsData$_index2;
    if (!isAlert) {
      var _ecsData$_id, _ecsData$_index;
      return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
        eventId: (_ecsData$_id = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id !== void 0 ? _ecsData$_id : '',
        index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
        type: _common.AttachmentType.event
      }] : [];
    }
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: (_ecsData$_id2 = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id2 !== void 0 ? _ecsData$_id2 : '',
      index: (_ecsData$_index2 = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index2 !== void 0 ? _ecsData$_index2 : '',
      type: _common.AttachmentType.alert,
      rule: casesUi.helpers.getRuleIdFromEvent({
        ecs: ecsData,
        data: nonEcsData !== null && nonEcsData !== void 0 ? nonEcsData : []
      })
    }] : [];
  }, [casesUi.helpers, ecsData, isAlert, nonEcsData]);
  const onCaseSuccess = (0, _react.useCallback)(() => {
    if (onSuccess) {
      onSuccess();
    }
    if (refetch) {
      refetch();
    }
  }, [onSuccess, refetch]);
  const createCaseArgs = (0, _react.useMemo)(() => {
    return {
      onClose: onMenuItemClick,
      onSuccess: onCaseSuccess
    };
  }, [onMenuItemClick, onCaseSuccess]);
  const createCaseFlyout = casesUi.hooks.useCasesAddToNewCaseFlyout(createCaseArgs);
  const selectCaseArgs = (0, _react.useMemo)(() => {
    return {
      onClose: onMenuItemClick,
      onSuccess: onCaseSuccess
    };
  }, [onMenuItemClick, onCaseSuccess]);
  const selectCaseModal = casesUi.hooks.useCasesAddToExistingCaseModal(selectCaseArgs);
  const observables = (0, _react.useMemo)(() => casesUi.helpers.getObservablesFromEcs(nonEcsData ? [nonEcsData] : []), [casesUi.helpers, nonEcsData]);
  const handleAddToNewCaseClick = (0, _react.useCallback)(() => {
    // TODO rename this, this is really `closePopover()`
    onMenuItemClick();
    createCaseFlyout.open({
      attachments: caseAttachments,
      observables
    });
  }, [onMenuItemClick, createCaseFlyout, caseAttachments, observables]);
  const handleAddToExistingCaseClick = (0, _react.useCallback)(() => {
    // TODO rename this, this is really `closePopover()`
    onMenuItemClick();
    selectCaseModal.open({
      getAttachments: () => caseAttachments,
      getObservables: observables ? () => observables : undefined
    });
  }, [caseAttachments, onMenuItemClick, observables, selectCaseModal]);
  const addToCaseActionItems = (0, _react.useMemo)(() => {
    if (userCasesPermissions.createComment && userCasesPermissions.read) {
      return [
      // add to existing case menu item
      {
        'aria-label': ariaLabel,
        'data-test-subj': 'add-to-existing-case-action',
        key: 'add-to-existing-case-action',
        onClick: handleAddToExistingCaseClick,
        size: 's',
        name: _translations.ADD_TO_EXISTING_CASE
      },
      // add to new case menu item
      {
        'aria-label': ariaLabel,
        'data-test-subj': 'add-to-new-case-action',
        key: 'add-to-new-case-action',
        onClick: handleAddToNewCaseClick,
        size: 's',
        name: _translations.ADD_TO_NEW_CASE
      }];
    }
    return [];
  }, [userCasesPermissions.createComment, userCasesPermissions.read, ariaLabel, handleAddToExistingCaseClick, handleAddToNewCaseClick]);
  return {
    addToCaseActionItems,
    handleAddToNewCaseClick,
    handleAddToExistingCaseClick
  };
};
exports.useAddToCaseActions = useAddToCaseActions;