"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertExceptionActions = void 0;
var _react = require("react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _use_endpoint_exceptions_capability = require("../../../../exceptions/hooks/use_endpoint_exceptions_capability");
var _user_info = require("../../user_info");
var _translations = require("../translations");
var _user_privileges = require("../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertExceptionActions = ({
  isEndpointAlert,
  onAddExceptionTypeClick
}) => {
  const canEditRules = (0, _user_privileges.useUserPrivileges)().rulesPrivileges.edit;
  const [{
    hasIndexWrite
  }] = (0, _user_info.useUserData)();
  const canWriteEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('crudEndpointExceptions');
  const handleDetectionExceptionModal = (0, _react.useCallback)(() => {
    onAddExceptionTypeClick();
  }, [onAddExceptionTypeClick]);
  const handleEndpointExceptionModal = (0, _react.useCallback)(() => {
    onAddExceptionTypeClick(_securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT);
  }, [onAddExceptionTypeClick]);
  const disabledAddEndpointException = !canWriteEndpointExceptions || !isEndpointAlert;
  const disabledAddException = !canEditRules || !hasIndexWrite;
  const exceptionActionItems = (0, _react.useMemo)(() => disabledAddException && disabledAddEndpointException ? [] : [{
    key: 'add-endpoint-exception-menu-item',
    'data-test-subj': 'add-endpoint-exception-menu-item',
    disabled: disabledAddEndpointException,
    onClick: handleEndpointExceptionModal,
    name: _translations.ACTION_ADD_ENDPOINT_EXCEPTION
  }, {
    key: 'add-exception-menu-item',
    'data-test-subj': 'add-exception-menu-item',
    disabled: disabledAddException,
    onClick: handleDetectionExceptionModal,
    name: _translations.ACTION_ADD_EXCEPTION
  }], [disabledAddEndpointException, disabledAddException, handleDetectionExceptionModal, handleEndpointExceptionModal]);
  return {
    exceptionActionItems
  };
};
exports.useAlertExceptionActions = useAlertExceptionActions;