"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptionProperties = exports.TREND_ID = exports.TREEMAP_ID = exports.TABLE_ID = exports.CHARTS_ID = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_ID = exports.TABLE_ID = 'table';
const TREND_ID = exports.TREND_ID = 'trend';
const TREEMAP_ID = exports.TREEMAP_ID = 'treemap';
const CHARTS_ID = exports.CHARTS_ID = 'charts';
const getOptionProperties = alertViewSelection => {
  const charts = {
    id: CHARTS_ID,
    'data-test-subj': `chart-select-${CHARTS_ID}`,
    label: i18n.CHARTS_TITLE,
    value: CHARTS_ID
  };
  switch (alertViewSelection) {
    case TABLE_ID:
      return {
        id: TABLE_ID,
        'data-test-subj': `chart-select-${TABLE_ID}`,
        label: i18n.COUNTS,
        value: TABLE_ID
      };
    case TREND_ID:
      return {
        id: TREND_ID,
        'data-test-subj': `chart-select-${TREND_ID}`,
        label: i18n.TREND,
        value: TREND_ID
      };
    case TREEMAP_ID:
      return {
        id: TREEMAP_ID,
        'data-test-subj': `chart-select-${TREEMAP_ID}`,
        label: i18n.TREEMAP,
        value: TREEMAP_ID
      };
    case CHARTS_ID:
      return charts;
    default:
      return charts;
  }
};
exports.getOptionProperties = getOptionProperties;