"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationSection = exports.CARD_TEST_ID = exports.ADD_INTEGRATIONS_BUTTON_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _integration_card = require("./integration_card");
var _use_navigate_to_integrations_page = require("../../../hooks/alert_summary/use_navigate_to_integrations_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/integrations/integration_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ADD_INTEGRATION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.integrations.addIntegrationButtonLabel', {
  defaultMessage: 'Add integration'
});
const CARD_TEST_ID = exports.CARD_TEST_ID = 'alert-summary-integration-card-';
const ADD_INTEGRATIONS_BUTTON_TEST_ID = exports.ADD_INTEGRATIONS_BUTTON_TEST_ID = 'alert-summary-add-integrations-button';
/**
 * Section rendered at the top of the alert summary page. It displays all EASE installed integrations
 * and allow the user to add more integrations by clicking on a button that links to a Fleet page.
 * Each integration card is also displaying the last time the sync happened (using streams).
 */
const IntegrationSection = exports.IntegrationSection = /*#__PURE__*/(0, _react.memo)(({
  packages
}) => {
  const navigateToIntegrationsPage = (0, _use_navigate_to_integrations_page.useNavigateToIntegrationsPage)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, packages.map(pkg => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: pkg.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_card.IntegrationCard, {
    "data-test-subj": `${CARD_TEST_ID}${pkg.name}`,
    integration: pkg,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": ADD_INTEGRATIONS_BUTTON_TEST_ID,
    iconType: "plusInCircle",
    onClick: navigateToIntegrationsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, ADD_INTEGRATION)));
});
IntegrationSection.displayName = 'IntegrationSection';