"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionTypeField = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../../../../common/endpoint/service/response_actions/utils");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("./translations");
var _utils2 = require("./utils");
var _user_privileges = require("../../../common/components/user_privileges");
var _constants = require("../../../../common/endpoint/service/response_actions/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/endpoint/action_type_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionTypeFieldComponent = ({
  basePath,
  disabled,
  readDefaultValueOnForm
}) => {
  const {
    endpointPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const [data] = (0, _hook_form_lib.useFormData)();
  const {
    docLinks: {
      links: {
        securitySolution: {
          responseActions
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const enabledActions = (0, _react.useMemo)(() => _constants.ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS, []);
  const fieldOptions = (0, _react.useMemo)(() => enabledActions.map(name => {
    const missingRbac = !(0, _utils.getRbacControl)({
      commandName: _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[name],
      privileges: endpointPrivileges
    });
    const currentActions = (0, _lodash.map)(data.responseActions, 'params.command');
    // we enable just one instance of each action
    const commandAlreadyExists = currentActions.includes(name);
    const isDisabled = commandAlreadyExists || missingRbac;
    return {
      value: name,
      inputDisplay: name,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_utils2.EndpointActionText, {
        name: name,
        isDisabled: missingRbac,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 28
        }
      }),
      disabled: isDisabled,
      'data-test-subj': `command-type-${name}`
    };
  }), [data.responseActions, enabledActions, endpointPrivileges]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: `${basePath}.command`,
    readDefaultValueOnForm: readDefaultValueOnForm,
    config: {
      label: _i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.commandLabel', {
        defaultMessage: 'Response action'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.responseActions.endpoint.commandDescription",
        defaultMessage: "Select an endpoint response action. The response action only runs on hosts with Elastic Defend installed. {docs}",
        values: {
          docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: responseActions,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 90,
              columnNumber: 17
            }
          }, _translations.LEARN_MORE)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 11
        }
      }),
      validations: [{
        validator: _helpers.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.validations.commandIsRequiredErrorMessage', {
          defaultMessage: 'Action is a required field.'
        }))
      }]
    },
    component: _components.SuperSelectField,
    isDisabled: disabled,
    componentProps: {
      euiFieldProps: {
        options: fieldOptions,
        placeholder: _translations.CHOOSE_FROM_THE_LIST,
        'data-test-subj': 'commandTypeField'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
const ActionTypeField = exports.ActionTypeField = /*#__PURE__*/_react.default.memo(ActionTypeFieldComponent);