"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _show_value_list_modal = require("../../../../value_list/components/show_value_list_modal");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _form = require("./form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/value_lists_management_flyout/table_helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlignedSpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS};
  vertical-align: middle;
`;
const buildColumns = (onExport, onDelete) => [{
  field: 'name',
  name: i18n.COLUMN_FILE_NAME,
  truncateText: false,
  render: (name, item) => /*#__PURE__*/_react.default.createElement(_show_value_list_modal.ShowValueListModal, {
    shouldShowContentIfModalNotAvailable: true,
    listId: item.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, name)
}, {
  field: 'type',
  name: i18n.COLUMN_TYPE,
  width: '15%',
  truncateText: true,
  render: type => {
    const option = _form.listFormOptions.find(({
      value
    }) => value === type);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option ? option.text : type);
  }
}, {
  field: 'created_at',
  name: i18n.COLUMN_UPLOAD_DATE,
  render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    value: value,
    fieldName: "created_at",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }),
  width: '30%'
}, {
  field: 'created_by',
  name: i18n.COLUMN_CREATED_BY,
  truncateText: true,
  width: '20%'
}, {
  name: i18n.COLUMN_ACTIONS,
  actions: [{
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ACTION_EXPORT_DESCRIPTION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, item.isExporting ? /*#__PURE__*/_react.default.createElement(AlignedSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ACTION_EXPORT_DESCRIPTION,
      "data-test-subj": "action-export-value-list",
      iconType: "exportAction",
      onClick: () => onExport(item),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }))
  }, {
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.ACTION_DELETE_DESCRIPTION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, item.isDeleting ? /*#__PURE__*/_react.default.createElement(AlignedSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": i18n.ACTION_DELETE_DESCRIPTION,
      "data-test-subj": `action-delete-value-list-${item.name}`,
      iconType: "trash",
      color: "danger",
      onClick: () => onDelete(item),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }))
  }],
  width: '15%'
}];
exports.buildColumns = buildColumns;