"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasActionsPrivileges = void 0;
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHasActionsPrivileges = () => {
  const {
    services: {
      application: {
        capabilities: {
          actions
        }
      }
    }
  } = (0, _kibana.useKibana)();
  return (0, _privileges.isBoolean)(actions.show) ? actions.show : true;
};
exports.useHasActionsPrivileges = useHasActionsPrivileges;