"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesColumns = exports.useRuleExecutionStatusColumn = exports.useMonitoringColumns = exports.useGapStatusColumn = exports.useGapDurationColumn = exports.useEnabledColumn = exports.TOTAL_UNFILLED_DURATION_COLUMN = exports.SEARCH_DURATION_COLUMN = exports.RuleLink = exports.RULE_NAME_COLUMN = exports.LAST_EXECUTION_COLUMN = exports.INDEXING_DURATION_COLUMN = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/alerting-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _rules_table_empty_column_name = require("./rules_table_empty_column_name");
var _constants = require("../../../../../common/constants");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _rule_snooze_badge = require("../../../rule_management/components/rule_snooze_badge");
var _formatted_date = require("../../../../common/components/formatted_date");
var _links = require("../../../../common/components/links");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _popover_items = require("../../../../common/components/popover_items");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var _integrations_popover = require("../../../common/components/related_integrations/integrations_popover");
var _rule_execution_status = require("../../../common/components/rule_execution_status");
var _rule_switch = require("../../../common/components/rule_switch");
var _severity_badge = require("../../../../common/components/severity_badge");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _use_rule_details_tabs = require("../../../rule_details_ui/pages/rule_details/use_rule_details_tabs");
var _popover_tooltip = require("./popover_tooltip");
var _rules_table_context = require("./rules_table/rules_table_context");
var _table_header_tooltip_cell = require("./table_header_tooltip_cell");
var _use_has_actions_privileges = require("./use_has_actions_privileges");
var _use_has_ml_permissions = require("./use_has_ml_permissions");
var _use_rules_table_actions = require("./use_rules_table_actions");
var _ml_rule_warning_popover = require("../ml_rule_warning_popover/ml_rule_warning_popover");
var _helpers2 = require("../../../common/helpers");
var _translations2 = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/use_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const loadingActionsSet = new Set(['disable', 'enable', 'edit', 'delete', 'run', 'fill_gaps']);
const useEnabledColumn = ({
  hasCRUDPermissions,
  startMlJobs
}) => {
  const hasMlPermissions = (0, _use_has_ml_permissions.useHasMlPermissions)();
  const hasActionsPrivileges = (0, _use_has_actions_privileges.useHasActionsPrivileges)();
  const {
    loadingRulesAction,
    loadingRuleIds
  } = (0, _rules_table_context.useRulesTableContext)().state;
  const loadingIds = (0, _react.useMemo)(() => loadingActionsSet.has(loadingRulesAction !== null && loadingRulesAction !== void 0 ? loadingRulesAction : '') ? loadingRuleIds : [], [loadingRuleIds, loadingRulesAction]);
  return (0, _react.useMemo)(() => ({
    field: 'enabled',
    name: i18n.COLUMN_ENABLE,
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _privileges.explainLackOfPermission)(rule, hasMlPermissions, hasActionsPrivileges, hasCRUDPermissions),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_switch.RuleSwitch, {
      id: rule.id,
      enabled: rule.enabled,
      startMlJobsIfNeeded: () => startMlJobs((0, _helpers2.getMachineLearningJobId)(rule)),
      isDisabled: !(0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges) || !hasCRUDPermissions || (0, _helpers.isMlRule)(rule.type) && !hasMlPermissions,
      isLoading: loadingIds.includes(rule.id),
      ruleName: rule.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 11
      }
    })),
    width: '95px',
    sortable: true
  }), [hasMlPermissions, hasActionsPrivileges, hasCRUDPermissions, loadingIds, startMlJobs]);
};
exports.useEnabledColumn = useEnabledColumn;
const useRuleSnoozeColumn = () => {
  return (0, _react.useMemo)(() => ({
    field: 'snooze',
    name: i18n.COLUMN_SNOOZE,
    render: (_, rule) => /*#__PURE__*/_react.default.createElement(_rule_snooze_badge.RuleSnoozeBadge, {
      ruleId: rule.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 34
      }
    }),
    width: '100px',
    sortable: false
  }), []);
};
const RuleLink = ({
  name,
  id
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: name,
    anchorClassName: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    "data-test-subj": "ruleName",
    deepLinkId: _constants.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getRuleDetailsTabUrl)(id, _use_rule_details_tabs.RuleDetailTabs.alerts),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, name));
};
exports.RuleLink = RuleLink;
const RULE_NAME_COLUMN = exports.RULE_NAME_COLUMN = {
  field: 'name',
  name: i18n.COLUMN_RULE,
  render: (value, item) => /*#__PURE__*/_react.default.createElement(RuleLink, {
    id: item.id,
    name: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 48
    }
  }),
  sortable: true,
  truncateText: true,
  width: '38%'
};
const useRuleExecutionStatusColumn = ({
  sortable,
  width,
  isLoadingJobs,
  mlJobs
}) => {
  return (0, _react.useMemo)(() => ({
    field: 'execution_summary.last_execution.status',
    name: i18n.COLUMN_LAST_RESPONSE,
    render: (value, item) => {
      var _item$execution_summa;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatusBadge, {
        status: value,
        message: (_item$execution_summa = item.execution_summary) === null || _item$execution_summa === void 0 ? void 0 : _item$execution_summa.last_execution.message,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_ml_rule_warning_popover.MlRuleWarningPopover, {
        rule: item,
        loadingJobs: isLoadingJobs,
        jobs: mlJobs,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 15
        }
      })));
    },
    sortable,
    truncateText: true,
    width
  }), [isLoadingJobs, mlJobs, sortable, width]);
};
exports.useRuleExecutionStatusColumn = useRuleExecutionStatusColumn;
const TAGS_COLUMN = {
  field: 'tags',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_TAGS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: tags => {
    if (tags == null || tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 7
      }
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.COLUMN_TAGS,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 7
      }
    });
  },
  width: '65px',
  truncateText: true
};
const INTEGRATIONS_COLUMN = {
  field: 'related_integrations',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_INTEGRATIONS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: integrations => {
    if (integrations == null || integrations.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_integrations_popover.IntegrationsPopover, {
      relatedIntegrations: integrations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 12
      }
    });
  },
  width: '70px',
  truncateText: true
};
const MODIFIED_COLUMN = {
  field: 'rule_source',
  name: /*#__PURE__*/_react.default.createElement(_rules_table_empty_column_name.RulesTableEmptyColumnName, {
    name: i18n.COLUMN_MODIFIED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }),
  align: 'center',
  render: ruleSource => {
    if (ruleSource == null || ruleSource.type === 'internal' || ruleSource.type === 'external' && ruleSource.is_customized === false) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.MODIFIED_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      tabIndex: 0,
      color: "hollow",
      "data-test-subj": "rulesTableModifiedColumnBadge",
      "aria-label": i18n.MODIFIED_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 9
      }
    }, i18n.MODIFIED_LABEL));
  },
  width: '90px',
  truncateText: true
};
const LAST_EXECUTION_COLUMN = exports.LAST_EXECUTION_COLUMN = {
  field: 'execution_summary.last_execution.date',
  name: i18n.COLUMN_LAST_COMPLETE_RUN,
  render: value => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "ruleLastRun",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 7
      }
    }, value == null ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      tooltipFieldName: i18n.COLUMN_LAST_COMPLETE_RUN,
      relativeThresholdInHrs: _constants.DEFAULT_RELATIVE_DATE_THRESHOLD,
      value: value,
      tooltipAnchorClassName: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 11
      }
    }));
  },
  sortable: true,
  truncateText: true,
  width: '16%'
};
const useActionsColumn = ({
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const actions = (0, _use_rules_table_actions.useRulesTableActions)({
    showExceptionsDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  return (0, _react.useMemo)(() => ({
    actions,
    width: '40px'
  }), [actions]);
};
const useRulesColumns = ({
  hasCRUDPermissions,
  isLoadingJobs,
  mlJobs,
  startMlJobs,
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const actionsColumn = useActionsColumn({
    showExceptionsDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const enabledColumn = useEnabledColumn({
    hasCRUDPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs
  });
  const executionStatusColumn = useRuleExecutionStatusColumn({
    sortable: true,
    width: '16%',
    isLoadingJobs,
    mlJobs
  });
  const snoozeColumn = useRuleSnoozeColumn();
  return (0, _react.useMemo)(() => [RULE_NAME_COLUMN, MODIFIED_COLUMN, ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, {
    field: 'risk_score',
    name: i18n.COLUMN_RISK_SCORE,
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "riskScore",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 11
      }
    }, value),
    sortable: true,
    truncateText: true,
    width: '85px'
  }, {
    field: 'severity',
    name: i18n.COLUMN_SEVERITY,
    render: value => /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 46
      }
    }),
    sortable: true,
    truncateText: true,
    width: '12%'
  }, LAST_EXECUTION_COLUMN, executionStatusColumn, {
    field: 'updated_at',
    name: i18n.COLUMN_LAST_UPDATE,
    render: value => {
      return value == null ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        tooltipFieldName: i18n.COLUMN_LAST_UPDATE,
        relativeThresholdInHrs: _constants.DEFAULT_RELATIVE_DATE_THRESHOLD,
        value: value,
        tooltipAnchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 390,
          columnNumber: 13
        }
      });
    },
    sortable: true,
    width: '18%',
    truncateText: true
  }, snoozeColumn, enabledColumn, ...(hasCRUDPermissions ? [actionsColumn] : [])], [showRelatedIntegrations, executionStatusColumn, snoozeColumn, enabledColumn, hasCRUDPermissions, actionsColumn]);
};
exports.useRulesColumns = useRulesColumns;
const INDEXING_DURATION_COLUMN = exports.INDEXING_DURATION_COLUMN = {
  field: 'execution_summary.last_execution.metrics.total_indexing_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_INDEXING_TIMES,
    tooltipContent: i18n.COLUMN_INDEXING_TIMES_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 5
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "total_indexing_duration_ms",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 5
    }
  }, value != null ? value.toFixed() : (0, _empty_value.getEmptyTagValue)()),
  sortable: true,
  truncateText: true,
  width: '16%'
};
const SEARCH_DURATION_COLUMN = exports.SEARCH_DURATION_COLUMN = {
  field: 'execution_summary.last_execution.metrics.total_search_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_QUERY_TIMES,
    tooltipContent: i18n.COLUMN_QUERY_TIMES_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 5
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "total_search_duration_ms",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 5
    }
  }, value != null ? value.toFixed() : (0, _empty_value.getEmptyTagValue)()),
  sortable: true,
  truncateText: true,
  width: '14%'
};
const useGapDurationColumn = () => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  return {
    field: 'execution_summary.last_execution.metrics.execution_gap_duration_s',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.COLUMN_GAP,
      customTooltip: /*#__PURE__*/_react.default.createElement("div", {
        css: {
          maxWidth: '20px'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 462,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
        columnName: i18n.COLUMN_GAP,
        anchorColor: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        css: {
          width: 300
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 464,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Duration of most recent gap in Rule execution. Adjust Rule look-back or {seeDocs} for mitigating gaps.",
        id: "xpack.securitySolution.detectionEngine.rules.allRules.columns.gapTooltip",
        values: {
          seeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: `${docLinks.links.siem.troubleshootGaps}`,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 470,
              columnNumber: 23
            }
          }, i18n.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 465,
          columnNumber: 17
        }
      })))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 7
      }
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "gap",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 7
      }
    }, value != null ? _moment.default.duration(value, 'seconds').humanize() : (0, _empty_value.getEmptyTagValue)()),
    sortable: true,
    truncateText: true,
    width: '14%'
  };
};
exports.useGapDurationColumn = useGapDurationColumn;
const GapFillStatusTooltip = ({
  totalInProgressDurationMs,
  totalUnfilledDurationMs,
  totalFilledDurationMs
}) => {
  const formatDurationHumanized = duration => {
    return duration === 0 ? '0 ms' : _moment.default.duration(duration, 'ms').humanize();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 7
    }
  }, (0, _translations2.gapStatusTooltipInProgress)(formatDurationHumanized(totalInProgressDurationMs !== null && totalInProgressDurationMs !== void 0 ? totalInProgressDurationMs : 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 510,
      columnNumber: 7
    }
  }, (0, _translations2.gapStatusTooltipUnfilled)(formatDurationHumanized(totalUnfilledDurationMs !== null && totalUnfilledDurationMs !== void 0 ? totalUnfilledDurationMs : 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 7
    }
  }, (0, _translations2.gapStatusTooltipFilled)(formatDurationHumanized(totalFilledDurationMs !== null && totalFilledDurationMs !== void 0 ? totalFilledDurationMs : 0))));
};
const useGapStatusColumn = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => ({
    field: 'gap_info',
    name: _translations2.GAP_STATUS_HEADER,
    render: gapInfo => {
      var _gapInfo$gap_fill_sta, _byStatus$status, _byStatus$status2;
      const status = (_gapInfo$gap_fill_sta = gapInfo === null || gapInfo === void 0 ? void 0 : gapInfo.gap_fill_status) !== null && _gapInfo$gap_fill_sta !== void 0 ? _gapInfo$gap_fill_sta : undefined;
      if (!gapInfo || !status) return (0, _empty_value.getEmptyTagValue)();
      const totalInProgressDurationMs = gapInfo.total_in_progress_duration_ms;
      const totalUnfilledDurationMs = gapInfo.total_unfilled_duration_ms;
      const totalFilledDurationMs = gapInfo.total_filled_duration_ms;
      const byStatus = {
        [_common.gapFillStatus.IN_PROGRESS]: {
          color: euiTheme.colors.backgroundBaseWarning,
          label: _translations2.GAP_STATUS_IN_PROGRESS_LABEL
        },
        [_common.gapFillStatus.UNFILLED]: {
          color: euiTheme.colors.backgroundBaseDanger,
          label: _translations2.GAP_STATUS_UNFILLED_LABEL
        },
        [_common.gapFillStatus.FILLED]: {
          color: euiTheme.colors.backgroundBaseSuccess,
          label: _translations2.GAP_STATUS_FILLED_LABEL
        }
      };
      const color = (_byStatus$status = byStatus[status]) === null || _byStatus$status === void 0 ? void 0 : _byStatus$status.color;
      const label = (_byStatus$status2 = byStatus[status]) === null || _byStatus$status2 === void 0 ? void 0 : _byStatus$status2.label;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: /*#__PURE__*/_react.default.createElement(GapFillStatusTooltip, {
          totalInProgressDurationMs: totalInProgressDurationMs,
          totalUnfilledDurationMs: totalUnfilledDurationMs,
          totalFilledDurationMs: totalFilledDurationMs,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 557,
            columnNumber: 15
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 554,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        tabIndex: 0,
        color: color,
        "data-test-subj": "gapStatusBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 564,
          columnNumber: 13
        }
      }, label));
    },
    sortable: false,
    truncateText: true,
    width: '120px'
  }), [euiTheme.colors.backgroundBaseWarning, euiTheme.colors.backgroundBaseDanger, euiTheme.colors.backgroundBaseSuccess]);
};
exports.useGapStatusColumn = useGapStatusColumn;
const TOTAL_UNFILLED_DURATION_COLUMN = exports.TOTAL_UNFILLED_DURATION_COLUMN = {
  field: 'gap_info.total_unfilled_duration_ms',
  name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
    title: i18n.COLUMN_TOTAL_UNFILLED_GAPS_DURATION,
    tooltipContent: i18n.COLUMN_TOTAL_UNFILLED_GAPS_DURATION_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 5
    }
  }),
  render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "gap_info",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 591,
      columnNumber: 5
    }
  }, value != null && value > 0 ? _moment.default.duration(value, 'ms').humanize() : (0, _empty_value.getEmptyTagValue)()),
  sortable: false,
  truncateText: true,
  width: '14%'
};
const useMonitoringColumns = ({
  hasCRUDPermissions,
  isLoadingJobs,
  mlJobs,
  startMlJobs,
  showExceptionsDuplicateConfirmation,
  showManualRuleRunConfirmation,
  confirmDeletion
}) => {
  const actionsColumn = useActionsColumn({
    showExceptionsDuplicateConfirmation,
    showManualRuleRunConfirmation,
    confirmDeletion
  });
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const enabledColumn = useEnabledColumn({
    hasCRUDPermissions,
    isLoadingJobs,
    mlJobs,
    startMlJobs
  });
  const executionStatusColumn = useRuleExecutionStatusColumn({
    sortable: true,
    width: '12%',
    isLoadingJobs,
    mlJobs
  });
  const gapDurationColumn = useGapDurationColumn();
  const gapStatusColumn = useGapStatusColumn();
  return (0, _react.useMemo)(() => [{
    ...RULE_NAME_COLUMN,
    width: '28%'
  }, MODIFIED_COLUMN, ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, INDEXING_DURATION_COLUMN, SEARCH_DURATION_COLUMN, gapStatusColumn, gapDurationColumn, TOTAL_UNFILLED_DURATION_COLUMN, executionStatusColumn, LAST_EXECUTION_COLUMN, enabledColumn, ...(hasCRUDPermissions ? [actionsColumn] : [])], [actionsColumn, enabledColumn, executionStatusColumn, gapDurationColumn, hasCRUDPermissions, showRelatedIntegrations, gapStatusColumn]);
};
exports.useMonitoringColumns = useMonitoringColumns;