"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GapFillStatusSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("@kbn/alerting-plugin/common");
var _reactHooks = require("@kbn/react-hooks");
var _translations = require("../../../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_table_filters/gap_fill_status_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GapFillStatusSelector = ({
  selectedStatuses,
  onSelectedStatusesChanged
}) => {
  const [isOpen, {
    off: close,
    toggle
  }] = (0, _reactHooks.useBoolean)(false);
  const options = (0, _react.useMemo)(() => [{
    label: _translations.GAP_FILL_STATUS_IN_PROGRESS,
    data: {
      status: _common.gapFillStatus.IN_PROGRESS
    },
    checked: selectedStatuses.includes(_common.gapFillStatus.IN_PROGRESS) ? 'on' : undefined
  }, {
    label: _translations.GAP_FILL_STATUS_UNFILLED,
    data: {
      status: _common.gapFillStatus.UNFILLED
    },
    checked: selectedStatuses.includes(_common.gapFillStatus.UNFILLED) ? 'on' : undefined
  }, {
    label: _translations.GAP_FILL_STATUS_FILLED,
    data: {
      status: _common.gapFillStatus.FILLED
    },
    checked: selectedStatuses.includes(_common.gapFillStatus.FILLED) ? 'on' : undefined
  }], [selectedStatuses]);
  const onChange = newOptions => {
    const statuses = newOptions.filter(option => option.checked === 'on').map(option => {
      var _option$data;
      return (_option$data = option.data) === null || _option$data === void 0 ? void 0 : _option$data.status;
    }).filter(status => status != null);
    onSelectedStatusesChanged(statuses);
  };
  const trigger = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: toggle,
    numFilters: options.length,
    isSelected: isOpen,
    hasActiveFilters: selectedStatuses.length > 0,
    numActiveFilters: selectedStatuses.length,
    "data-test-subj": "gapFillStatusFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, _translations.GAP_FILL_STATUS_FILTER_LABEL);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: trigger,
    isOpen: isOpen,
    closePopover: close,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _translations.GAP_FILL_STATUS_FILTER_LABEL,
    options: options,
    onChange: onChange,
    listProps: {
      isVirtualized: false
    },
    "data-test-subj": "gapFillStatusFilterSelectableList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              width: 220px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, list)));
};
exports.GapFillStatusSelector = GapFillStatusSelector;