"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllRules = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_route_spy = require("../../../../common/utils/route/use_route_spy");
var _use_sync_rules_table_saved_state = require("./rules_table/use_sync_rules_table_saved_state");
var _rules_tables = require("./rules_tables");
var _rules_table_toolbar = require("./rules_table_toolbar");
var _upgrade_prebuilt_rules_table = require("./upgrade_prebuilt_rules_table/upgrade_prebuilt_rules_table");
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table/upgrade_prebuilt_rules_table_context");
var _rule_gaps_callout = require("../../../rule_gaps/components/rule_gaps_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Table Component for displaying all Rules for a given cluster. Provides the ability to filter
 * by name, sort by enabled, and perform the following actions:
 *   * Enable/Disable
 *   * Duplicate
 *   * Delete
 *   * Import/Export
 */
const AllRules = exports.AllRules = /*#__PURE__*/_react.default.memo(() => {
  (0, _use_sync_rules_table_saved_state.useSyncRulesTableSavedState)();
  const [{
    tabName
  }] = (0, _use_route_spy.useRouteSpy)();
  if (tabName !== _rules_table_toolbar.AllRulesTabs.updates) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tabName !== _rules_table_toolbar.AllRulesTabs.monitoring && /*#__PURE__*/_react.default.createElement(_rule_gaps_callout.RuleGapsCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 49
      }
    }), /*#__PURE__*/_react.default.createElement(_rules_table_toolbar.RulesTableToolbar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_rules_tables.RulesTables, {
      selectedTab: tabName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table_context.UpgradePrebuiltRulesTableContextProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_rules_table_toolbar.RulesTableToolbar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_upgrade_prebuilt_rules_table.UpgradePrebuiltRulesTable, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }));
  }
});
AllRules.displayName = 'AllRules';