"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetAlertSuppressionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../common/constants");
var _telemetry = require("../../../../../../common/lib/telemetry");
var _constants2 = require("../../../../../../../common/detection_engine/constants");
var _source = require("../../../../../../common/containers/source");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _alert_suppression_edit = require("../../../../../rule_creation/components/alert_suppression_edit");
var _types = require("../../../../../common/types");
var _translations = require("../translations");
var _use_terms_aggregation_fields = require("../../../../../../common/hooks/use_terms_aggregation_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/set_alert_suppression_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formSchema = {
  [_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: {
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_translations.bulkAlertSuppression.SUPPRESSION_REQUIRED_ERROR)
    }, {
      validator: _shared_imports.fieldValidators.maxLengthField({
        message: _translations.bulkAlertSuppression.SUPPRESSION_MAX_LENGTH_ERROR,
        length: 3
      })
    }]
  }
};
const initialFormData = {
  [_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]: [],
  [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME]: _types.AlertSuppressionDurationType.PerRuleExecution,
  [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]: _alert_suppression_edit.ALERT_SUPPRESSION_DEFAULT_DURATION,
  [_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME]: _constants2.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY
};
const SetAlertSuppressionForm = exports.SetAlertSuppressionForm = /*#__PURE__*/_react.default.memo(function SetAlertSuppressionForm({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema: formSchema
  });
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  const [_, {
    indexPatterns
  }] = (0, _source.useFetchIndex)(defaultPatterns, false);
  const suppressibleFields = (0, _use_terms_aggregation_fields.useTermsAggregationFields)(indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns.fields);
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const durationValue = data[_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME] === _types.AlertSuppressionDurationType.PerTimePeriod ? data[_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME] : undefined;
    const suppressionPayload = {
      value: {
        group_by: data.alertSuppressionFields,
        missing_fields_strategy: data[_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME],
        duration: durationValue
      },
      type: _rule_management.BulkActionEditTypeEnum.set_alert_suppression
    };
    onConfirm(suppressionPayload);
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.SET_ALERT_SUPPRESSION);
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: _translations.bulkAlertSuppression.SET_TITLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, _translations.bulkAlertSuppression.SUPPRESSION_INFO_TEXT))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_suppression_edit.AlertSuppressionEdit, {
    suppressibleFields: suppressibleFields,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
});