"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCoverageOverviewMitreGraph = buildCoverageOverviewMitreGraph;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The order the tactic columns will appear in on the coverage overview page
const tacticOrder = ['TA0043', 'TA0042', 'TA0001', 'TA0002', 'TA0003', 'TA0004', 'TA0005', 'TA0006', 'TA0007', 'TA0008', 'TA0009', 'TA0011', 'TA0010', 'TA0040'];
function buildCoverageOverviewMitreGraph(tactics, techniques, subtechniques) {
  const techniqueToSubtechniquesMap = new Map(); // Map(TechniqueId -> SubTechniqueId[])

  for (const subtechnique of subtechniques) {
    const coverageOverviewMitreSubTechnique = {
      id: subtechnique.id,
      name: subtechnique.name,
      reference: subtechnique.reference,
      enabledRules: [],
      disabledRules: [],
      availableRules: []
    };
    const techniqueSubtechniques = techniqueToSubtechniquesMap.get(subtechnique.techniqueId);
    if (!techniqueSubtechniques) {
      techniqueToSubtechniquesMap.set(subtechnique.techniqueId, [coverageOverviewMitreSubTechnique]);
    } else {
      techniqueSubtechniques.push(coverageOverviewMitreSubTechnique);
    }
  }
  const tacticToTechniquesMap = new Map(); // Map(kebabCase(tactic name) -> CoverageOverviewMitreTechnique)

  for (const technique of techniques) {
    var _techniqueToSubtechni;
    const relatedSubtechniques = (_techniqueToSubtechni = techniqueToSubtechniquesMap.get(technique.id)) !== null && _techniqueToSubtechni !== void 0 ? _techniqueToSubtechni : [];
    for (const kebabCaseTacticName of technique.tactics) {
      const coverageOverviewMitreTechnique = {
        id: technique.id,
        name: technique.name,
        reference: technique.reference,
        subtechniques: relatedSubtechniques,
        enabledRules: [],
        disabledRules: [],
        availableRules: []
      };
      const tacticTechniques = tacticToTechniquesMap.get(kebabCaseTacticName);
      if (!tacticTechniques) {
        tacticToTechniquesMap.set(kebabCaseTacticName, [coverageOverviewMitreTechnique]);
      } else {
        tacticTechniques.push(coverageOverviewMitreTechnique);
      }
    }
  }
  const sortedTactics = tactics.sort((a, b) => tacticOrder.indexOf(a.id) - tacticOrder.indexOf(b.id));
  const result = [];
  for (const tactic of sortedTactics) {
    var _tacticToTechniquesMa;
    result.push({
      id: tactic.id,
      name: tactic.name,
      reference: tactic.reference,
      techniques: (_tacticToTechniquesMa = tacticToTechniquesMap.get((0, _lodash.kebabCase)(tactic.name))) !== null && _tacticToTechniquesMa !== void 0 ? _tacticToTechniquesMa : [],
      enabledRules: [],
      disabledRules: [],
      availableRules: []
    });
  }
  return result;
}