"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleUpdateCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _user_privileges = require("../../../common/components/user_privileges");
var _rule_update_callout = require("../components/rule_details/rule_update_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/hooks/use_rule_update_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useRuleUpdateCallout = ({
  rule,
  message,
  actionButton,
  onUpgrade
}) => {
  const canEditRules = (0, _user_privileges.useUserPrivileges)().rulesPrivileges.edit;
  return !rule || rule.rule_source.type !== 'external' || !canEditRules ? null : /*#__PURE__*/_react.default.createElement(_rule_update_callout.RuleUpdateCallout, {
    actionButton: actionButton,
    message: message,
    rule: rule,
    onUpgrade: onUpgrade,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  });
};
exports.useRuleUpdateCallout = useRuleUpdateCallout;