"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KqlQueryReadOnly = KqlQueryReadOnly;
var _react = _interopRequireDefault(require("react"));
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _inline_kql_query = require("./inline_kql_query");
var _saved_kql_query = require("./saved_kql_query");
var _utility_types = require("../../../../../../../../../common/utility_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/fields/kql_query/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function KqlQueryReadOnly({
  kqlQuery,
  dataSource,
  ruleType
}) {
  if (kqlQuery.type === _detection_engine.KqlQueryType.inline_query) {
    return /*#__PURE__*/_react.default.createElement(_inline_kql_query.InlineKqlQueryReadOnly, {
      kqlQuery: kqlQuery,
      dataSource: dataSource,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 12
      }
    });
  }
  if (kqlQuery.type === _detection_engine.KqlQueryType.saved_query) {
    return /*#__PURE__*/_react.default.createElement(_saved_kql_query.SavedKqlQueryReadOnly, {
      kqlQuery: kqlQuery,
      dataSource: dataSource,
      ruleType: ruleType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    });
  }
  return (0, _utility_types.assertUnreachable)(kqlQuery);
}