"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionEditAdapter = AlertSuppressionEditAdapter;
var _react = _interopRequireWildcard(require("react"));
var _alert_suppression_edit = require("../../../../../../../rule_creation/components/alert_suppression_edit");
var _utils = require("../../../../../../../rule_creation_ui/components/step_define_rule/utils");
var _utils2 = require("../../../../../../../../../common/detection_engine/utils");
var _hooks = require("../../../../../../../rule_creation_ui/hooks");
var _use_ml_rule_config = require("../../../../../../../../common/components/ml/hooks/use_ml_rule_config");
var _use_diffable_rule_data_view = require("../hooks/use_diffable_rule_data_view");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/alert_suppression/suppression_edit_adapter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AlertSuppressionEditAdapter({
  finalDiffableRule
}) {
  var _dataView$fields;
  const {
    dataView
  } = (0, _use_diffable_rule_data_view.useDiffableRuleDataView)(finalDiffableRule);
  const {
    fields: esqlSuppressionFields,
    isLoading: isEsqlSuppressionLoading
  } = (0, _hooks.useAllEsqlRuleFields)({
    esqlQuery: 'esql_query' in finalDiffableRule ? finalDiffableRule.esql_query.query : undefined,
    indexPatternsFields: (_dataView$fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : []
  });
  const machineLearningJobIds = (0, _react.useMemo)(() => 'machine_learning_job_id' in finalDiffableRule ? [finalDiffableRule.machine_learning_job_id].flat() : [], [finalDiffableRule]);
  const {
    mlSuppressionFields,
    loading: mlRuleConfigLoading,
    allJobsStarted
  } = (0, _use_ml_rule_config.useMLRuleConfig)({
    machineLearningJobId: machineLearningJobIds
  });
  const isMlSuppressionIncomplete = (0, _utils2.isMlRule)(finalDiffableRule.type) && machineLearningJobIds.length > 0 && !allJobsStarted;
  const suppressibleFieldSpecs = (0, _react.useMemo)(() => {
    if ((0, _utils2.isEsqlRule)(finalDiffableRule.type)) {
      return esqlSuppressionFields;
    } else if ((0, _utils2.isMlRule)(finalDiffableRule.type)) {
      return mlSuppressionFields;
    } else {
      var _dataView$fields2;
      return (0, _utils.getTermsAggregationFields)(((_dataView$fields2 = dataView === null || dataView === void 0 ? void 0 : dataView.fields) !== null && _dataView$fields2 !== void 0 ? _dataView$fields2 : []).filter(field => field.aggregatable === true));
    }
  }, [finalDiffableRule.type, esqlSuppressionFields, mlSuppressionFields, dataView === null || dataView === void 0 ? void 0 : dataView.fields]);
  const disabledText = (0, _react.useMemo)(() => {
    if ((0, _utils2.isMlRule)(finalDiffableRule.type) && mlRuleConfigLoading) {
      return i18n.MACHINE_LEARNING_SUPPRESSION_FIELDS_LOADING;
    } else if ((0, _utils2.isMlRule)(finalDiffableRule.type) && mlSuppressionFields.length === 0) {
      return i18n.MACHINE_LEARNING_NO_SUPPRESSION_FIELDS;
    } else if ((0, _utils2.isEsqlRule)(finalDiffableRule.type) && isEsqlSuppressionLoading) {
      return i18n.ESQL_SUPPRESSION_FIELDS_LOADING;
    }
  }, [finalDiffableRule, mlRuleConfigLoading, mlSuppressionFields.length, isEsqlSuppressionLoading]);
  return /*#__PURE__*/_react.default.createElement(_alert_suppression_edit.AlertSuppressionEdit, {
    suppressibleFields: suppressibleFieldSpecs,
    disabled: Boolean(disabledText),
    disabledText: disabledText,
    warningText: isMlSuppressionIncomplete ? i18n.MACHINE_LEARNING_SUPPRESSION_INCOMPLETE_LABEL : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  });
}