"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForTimestampOverride = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForTimestampOverride = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const oldFieldName = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.field_name);
  const newFieldName = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.field_name);
  if (oldFieldName !== newFieldName) {
    changes.push({
      subfieldName: 'field_name',
      oldSubfieldValue: oldFieldName,
      newSubfieldValue: newFieldName
    });
  }
  const oldVersionFallbackDisabled = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.fallback_disabled);
  const newVersionFallbackDisabled = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.fallback_disabled);
  if (oldVersionFallbackDisabled !== newVersionFallbackDisabled) {
    changes.push({
      subfieldName: 'fallback_disabled',
      oldSubfieldValue: oldVersionFallbackDisabled,
      newSubfieldValue: newVersionFallbackDisabled
    });
  }
  return changes;
};
exports.getSubfieldChangesForTimestampOverride = getSubfieldChangesForTimestampOverride;