"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRequiredFieldsStyles = exports.queryStyles = exports.filtersStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filtersStyles = exports.filtersStyles = {
  flexGroup: (0, _css.css)`
    max-width: 600px;
  `
};
const queryStyles = exports.queryStyles = {
  content: (0, _css.css)`
    white-space: pre-wrap;
  `
};
const useRequiredFieldsStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    font
  } = euiTheme;
  return (0, _react.useMemo)(() => {
    var _font$familyCode;
    return {
      fieldNameText: (0, _css.css)`
        font-family: ${(_font$familyCode = font.familyCode) !== null && _font$familyCode !== void 0 ? _font$familyCode : font.family};
        display: inline;
      `
    };
  }, [font.familyCode, font.family]);
};
exports.useRequiredFieldsStyles = useRequiredFieldsStyles;