"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_CLASS_NAME = exports.GUTTER_CLASS_NAME = exports.DARK_THEME_CLASS_NAME = exports.COLORS = exports.CODE_CLASS_NAME = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_CLASS_NAME = exports.TABLE_CLASS_NAME = 'rule-update-diff-table';
const CODE_CLASS_NAME = exports.CODE_CLASS_NAME = 'rule-update-diff-code';
const GUTTER_CLASS_NAME = exports.GUTTER_CLASS_NAME = 'rule-update-diff-gutter';
const DARK_THEME_CLASS_NAME = exports.DARK_THEME_CLASS_NAME = 'rule-update-diff-dark-theme';
const COLORS = exports.COLORS = {
  light: {
    gutterBackground: {
      deletion: 'rgb(255, 215, 213)',
      insertion: 'rgb(204, 255, 216)'
    },
    lineBackground: {
      deletion: 'rgb(255, 235, 233)',
      insertion: 'rgb(230, 255, 236)'
    },
    characterBackground: {
      deletion: 'rgba(255, 129, 130, 0.4)',
      insertion: 'rgb(171, 242, 188)'
    }
  },
  dark: {
    gutterBackground: {
      deletion: 'rgba(248, 81, 73, 0.3)',
      insertion: 'rgba(63, 185, 80, 0.3)'
    },
    lineBackground: {
      deletion: 'rgba(248, 81, 73, 0.1)',
      insertion: 'rgba(46, 160, 67, 0.15)'
    },
    characterBackground: {
      deletion: 'rgba(248, 81, 73, 0.4)',
      insertion: 'rgba(46, 160, 67, 0.4)'
    }
  }
};