"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NeedAdminForUpdateRulesCallOut = exports.NEED_ADMIN_CALLOUT_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _callouts = require("../../../../common/components/callouts");
var _user_info = require("../../../../detections/components/user_info");
var _links_to_docs = require("../../../../common/components/links_to_docs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/callouts/need_admin_for_update_rules_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NEED_ADMIN_CALLOUT_TEST_ID = exports.NEED_ADMIN_CALLOUT_TEST_ID = 'need-admin-for-update-rules';
const NEED_ADMIN_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertsPage.needAdminForUpdateCallOutBody.messageTitle', {
  defaultMessage: 'Administration permissions required for alert migration'
});
const needAdminForUpdateRulesMessage = {
  type: 'primary',
  id: NEED_ADMIN_CALLOUT_TEST_ID,
  title: NEED_ADMIN_CALLOUT_TITLE,
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.alertsPage.needAdminForUpdateCallOutBody.messageBody.messageDetail",
    defaultMessage: "{essence} Related documentation: {docs}",
    values: {
      essence: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.alertsPage.needAdminForUpdateCallOutBody.messageBody.essenceDescription",
        defaultMessage: "You are currently missing the required permissions to auto migrate your alert data. Please have your administrator visit this page one time to auto migrate your alert data.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 13
        }
      })),
      docs: /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("li", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_links_to_docs.DetectionsRequirementsLink, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement("li", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_links_to_docs.SecuritySolutionRequirementsLink, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 15
        }
      })))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  })
};

/**
 * Callout component that lets the user know that an administrator is needed for performing
 * and auto-update of signals or not. For this component to render the user must:
 * - Have the permissions to be able to read "signalIndexMappingOutdated" and that condition is "true"
 * - Have the permissions to be able to read "hasIndexManage" and that condition is "false"
 *
 * Some users do not have sufficient privileges to be able to determine if "signalIndexMappingOutdated"
 * is outdated or not. Same could apply to "hasIndexManage". When users do not have enough permissions
 * to determine if "signalIndexMappingOutdated" is true or false, the permissions system returns a "null"
 * instead.
 *
 * If the user has the permissions to see that signalIndexMappingOutdated is true and that
 * hasIndexManage is also true, then the user should be performing the update on the page which is
 * why we do not show it for that condition.
 */
const NeedAdminForUpdateRulesCallOut = exports.NeedAdminForUpdateRulesCallOut = /*#__PURE__*/(0, _react.memo)(() => {
  const [{
    signalIndexMappingOutdated,
    hasIndexManage
  }] = (0, _user_info.useUserData)();
  const shouldShowCallout = (0, _react.useMemo)(() => signalIndexMappingOutdated != null && signalIndexMappingOutdated && hasIndexManage != null && !hasIndexManage, [hasIndexManage, signalIndexMappingOutdated]);
  return shouldShowCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callouts.CallOutPersistentSwitcher, {
    condition: true,
    message: needAdminForUpdateRulesMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }));
});
NeedAdminForUpdateRulesCallOut.displayName = 'NeedAdminForUpdateRulesCallOut';