"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSettingsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_gap_auto_fill_scheduler = require("../../api/hooks/use_gap_auto_fill_scheduler");
var i18n = _interopRequireWildcard(require("../../translations"));
var _use_gap_auto_fill_capabilities = require("../../logic/use_gap_auto_fill_capabilities");
var _gap_auto_fill_logs = require("../gap_auto_fill_logs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_settings_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleSettingsModal = ({
  isOpen,
  onClose
}) => {
  const {
    canEditGapAutoFill,
    canAccessGapAutoFill
  } = (0, _use_gap_auto_fill_capabilities.useGapAutoFillCapabilities)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(isOpen);
  const query = (0, _use_gap_auto_fill_scheduler.useGetGapAutoFillScheduler)({
    enabled: canAccessGapAutoFill
  });
  const createMutation = (0, _use_gap_auto_fill_scheduler.useCreateGapAutoFillScheduler)();
  const updateMutation = (0, _use_gap_auto_fill_scheduler.useUpdateGapAutoFillScheduler)();
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [enabled, setEnabled] = (0, _react.useState)(false);
  const [isLogsFlyoutOpen, setIsLogsFlyoutOpen] = (0, _react.useState)(false);
  const gapAutoFillScheduler = query.data;
  (0, _react.useEffect)(() => {
    if (isOpen && query.data) {
      var _query$data$enabled, _query$data;
      const isEnabled = (_query$data$enabled = (_query$data = query.data) === null || _query$data === void 0 ? void 0 : _query$data.enabled) !== null && _query$data$enabled !== void 0 ? _query$data$enabled : false;
      setEnabled(isEnabled);
    }
  }, [isOpen, query.data]);
  const isSaving = createMutation.isLoading || updateMutation.isLoading;
  const isLoadingGapAutoFillScheduler = query.isLoading;
  const onSave = async () => {
    try {
      if (!gapAutoFillScheduler) {
        await createMutation.mutateAsync();
      } else {
        await updateMutation.mutateAsync({
          ...gapAutoFillScheduler,
          enabled
        });
      }
      addSuccess({
        title: i18n.AUTO_GAP_FILL_TOAST_TITLE,
        text: i18n.AUTO_GAP_FILL_TOAST_TEXT
      });
      onClose();
    } catch (err) {
      addError(err, {
        title: i18n.AUTO_GAP_FILL_TOAST_TITLE
      });
    }
  };
  if (!canAccessGapAutoFill) return null;
  const isFormElementDisabled = isSaving || isLoadingGapAutoFillScheduler || !canEditGapAutoFill;
  const isSaveBtnDisabled = !enabled && !gapAutoFillScheduler || isFormElementDisabled;
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, isModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    style: {
      width: 600
    },
    onClose: () => {
      onClose();
    },
    "aria-labelledby": i18n.RULE_SETTINGS_TITLE,
    "data-test-subj": "rule-settings-modal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, i18n.RULE_SETTINGS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, i18n.GAP_AUTO_FILL_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "rule-settings-enable-switch",
    label: i18n.GAP_AUTO_FILL_TOGGLE_LABEL,
    checked: enabled,
    onChange: e => setEnabled(e.target.checked),
    disabled: isSaving || !canEditGapAutoFill || isLoadingGapAutoFillScheduler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.ruleSettings.autoGapFillSchedulerDescriptionDetail",
    defaultMessage: "The Auto gap fill setting lets you specify whether you want to automatically fill execution gaps that are detected for rules. You can track the status and history of gap fill jobs from the {logsLink}.",
    values: {
      logsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => {
          setIsLogsFlyoutOpen(true);
          setIsModalOpen(false);
        },
        "data-test-subj": "gap-fill-scheduler-logs-link",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.ruleSettings.autoGapFillSchedulerLogsLinkText",
        defaultMessage: "Gap fill scheduler",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 25
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, i18n.RULE_SETTINGS_MODAL_CANCEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    isLoading: isSaving,
    isDisabled: isSaveBtnDisabled,
    "data-test-subj": "rule-settings-save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, i18n.RULE_SETTINGS_MODAL_SAVE))), /*#__PURE__*/_react.default.createElement(_gap_auto_fill_logs.GapAutoFillLogsFlyout, {
    isOpen: isLogsFlyoutOpen,
    onClose: () => onClose(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }));
};
exports.RuleSettingsModal = RuleSettingsModal;