"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleGaps = void 0;
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _header_section = require("../../../../common/components/header_section");
var _table_header_tooltip_cell = require("../../../rule_management_ui/components/rules_table/table_header_tooltip_cell");
var _formatted_date = require("../../../../common/components/formatted_date");
var _kibana = require("../../../../common/lib/kibana");
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _status_filter = require("./status_filter");
var _use_find_gaps_for_rule = require("../../api/hooks/use_find_gaps_for_rule");
var _fill_gap = require("./fill_gap");
var _fill_rule_gaps_button = require("./fill_rule_gaps_button");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_gaps/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatePickerEuiFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  max-width: 582px;
`;
const getGapsTableColumns = (hasCRUDPermissions, ruleId, enabled) => {
  const fillActions = {
    name: i18n.GAPS_TABLE_ACTIONS_LABEL,
    align: 'right',
    render: gap => /*#__PURE__*/_react.default.createElement(_fill_gap.FillGap, {
      isRuleEnabled: enabled,
      ruleId: ruleId,
      gap: gap,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 27
      }
    }),
    width: '15%'
  };
  const columns = [{
    field: 'status',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.GAPS_TABLE_STATUS_LABEL,
      tooltipContent: i18n.GAPS_TABLE_STATUS_LABEL_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }),
    render: (value, gap) => {
      const status = (0, _utils.getStatusLabel)(value);
      if (gap.failed_auto_fill_attempts != null && gap.failed_auto_fill_attempts > 0) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: i18n.GAPS_FAILED_AUTO_FILL_ATTEMPTS_TOOLTIP(gap.failed_auto_fill_attempts),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: "danger",
          "data-test-subj": "auto-fill-failed-attempts-indicator",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 15
          }
        }, status));
      }
      return status;
    },
    width: '10%'
  }, {
    field: '@timestamp',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.GAPS_TABLE_EVENT_TIME_LABEL,
      tooltipContent: i18n.GAPS_TABLE_EVENT_TIME_LABEL_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value,
      fieldName: '@timestamp',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }),
    width: '15%'
  }, {
    field: 'in_progress_intervals',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.GAPS_TABLE_MANUAL_FILL_TASKS_LABEL,
      tooltipContent: i18n.GAPS_TABLE_MANUAL_FILL_TASKS_LABEL_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }),
    render: value => {
      if (!value || !value.length) return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: 'primary',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 16
        }
      }, i18n.GAPS_TABLE_IN_PROGRESS_LABEL);
    },
    width: '10%'
  }, {
    width: '10%',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.GAPS_TABLE_EVENT_TIME_COVERED_LABEL,
      tooltipContent: i18n.GAPS_TABLE_EVENT_TIME_COVERED_LABEL_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }),
    render: item => {
      if (!item) return null;
      const value = Math.ceil(item.filled_duration_ms * 100 / item.total_gap_duration_ms);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        "data-test-subj": "rule-gaps-progress-bar",
        justifyContent: "flexEnd",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 17
        }
      }, value, '%'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: {
          maxWidth: '40px'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        value: value,
        max: 100,
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 15
        }
      })));
    }
  }, {
    field: 'range',
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.GAPS_TABLE_GAP_RANGE_LABEL,
      tooltipContent: i18n.GAPS_TABLE_GAP_RANGE_LABEL_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value === null || value === void 0 ? void 0 : value.gte,
      fieldName: 'start',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }), ' - ', /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value === null || value === void 0 ? void 0 : value.lte,
      fieldName: 'end',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    })),
    width: '40%'
  }, {
    field: 'total_gap_duration_ms',
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(_table_header_tooltip_cell.TableHeaderTooltipCell, {
      title: i18n.GAPS_TABLE_GAP_DURATION_LABEL,
      tooltipContent: i18n.GAPS_TABLE_GAP_DURATION_LABEL_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 9
      }
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", value != null ? _moment.default.duration(value, 'ms').humanize() : (0, _empty_value.getEmptyTagValue)()),
    width: '10%'
  }];
  if (hasCRUDPermissions) {
    columns.push(fillActions);
  }
  return columns;
};
const DEFAULT_PAGE_SIZE = 10;
const RuleGaps = ({
  ruleId,
  enabled
}) => {
  var _data$total, _data$data;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [dateRange, setDateRange] = (0, _react.useState)({
    start: 'now-24h',
    end: 'now'
  });
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const canEditRules = (0, _user_privileges.useUserPrivileges)().rulesPrivileges.edit;
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(1000);
  const [isPaused, setIsPaused] = (0, _react.useState)(true);
  const [selectedStatuses, setSelectedStatuses] = (0, _react.useState)([]);
  const isBulkFillRuleGapsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('bulkFillRuleGapsEnabled');
  const isFillRuleGapsButtonEnabled = canEditRules && isBulkFillRuleGapsEnabled;
  const [sort, setSort] = (0, _react.useState)({
    field: '@timestamp',
    direction: 'desc'
  });
  const getSortField = field => {
    if (field === '@timestamp' || !field) {
      return '@timestamp';
    }
    return `kibana.alert.rule.gap.${field}`;
  };
  const {
    data,
    isLoading,
    isError,
    isFetching,
    refetch,
    dataUpdatedAt
  } = (0, _use_find_gaps_for_rule.useFindGapsForRule)({
    ruleId,
    page: pageIndex + 1,
    perPage: pageSize,
    start: dateRange.start,
    end: dateRange.end,
    statuses: selectedStatuses,
    sortField: getSortField(sort.field),
    sortOrder: sort.direction
  });
  const totalItemCount = (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0;
  const MaxItemCount = 10000;
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: Math.min(totalItemCount, MaxItemCount)
  };
  const columns = getGapsTableColumns(canEditRules, ruleId, enabled);
  const onRefreshCallback = () => {
    refetch();
  };
  const handleTableChange = ({
    page,
    sort: newSort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
    if (newSort) {
      setSort(newSort);
    }
  };
  const onTimeChangeCallback = (0, _react.useCallback)(props => {
    setDateRange({
      start: props.start,
      end: props.end
    });
  }, [setDateRange]);
  const onRefreshChangeCallback = (0, _react.useCallback)(props => {
    setIsPaused(props.isPaused);
    // Only support auto-refresh >= 5s -- no current ability to limit within component
    setRefreshInterval(props.refreshInterval > 5000 ? props.refreshInterval : 5000);
  }, [setIsPaused, setRefreshInterval]);
  const handleStatusChange = (0, _react.useCallback)(statuses => {
    setSelectedStatuses(statuses);
  }, [setSelectedStatuses]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    "data-test-subj": "rule-gaps-info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: 'Gaps',
    subtitle: 'Rule gaps',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_status_filter.GapStatusFilter, {
    selectedItems: selectedStatuses,
    onChange: handleStatusChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(DatePickerEuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    "data-test-subj": "rule-gaps-date-picker",
    start: dateRange.start,
    end: dateRange.end,
    onTimeChange: onTimeChangeCallback,
    onRefresh: onRefreshCallback,
    isPaused: isPaused,
    isLoading: isFetching,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChangeCallback,
    width: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 17
    }
  }))), isFillRuleGapsButtonEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_fill_rule_gaps_button.FillRuleGapsButton, {
    ruleId: ruleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, totalItemCount > MaxItemCount && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }, i18n.GAPS_TABLE_TOTAL_GAPS_LABEL(totalItemCount, MaxItemCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, timelines.getLastUpdated({
    showUpdating: isLoading,
    updatedAt: dataUpdatedAt
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "rule-gaps-table",
    items: (_data$data = data === null || data === void 0 ? void 0 : data.data) !== null && _data$data !== void 0 ? _data$data : [],
    columns: columns,
    pagination: pagination,
    error: isError ? 'error' : undefined,
    loading: isLoading,
    onChange: handleTableChange,
    sorting: {
      sort
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 7
    }
  }));
};
exports.RuleGaps = RuleGaps;