"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapAutoFillStatusSkippedSomeSucceededTooltip = exports.getGapAutoFillStatusErrorSomeSucceededTooltip = exports.GAP_AUTO_FILL_STATUS_SUCCESS_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SUCCESS = exports.GAP_AUTO_FILL_STATUS_SKIPPED_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SKIPPED_RULES_DISABLED_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SKIPPED_NO_CAPACITY_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SKIPPED = exports.GAP_AUTO_FILL_STATUS_PANEL_TITLE = exports.GAP_AUTO_FILL_STATUS_NO_GAPS_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_NO_GAPS = exports.GAP_AUTO_FILL_STATUS_FILTER_TITLE = exports.GAP_AUTO_FILL_STATUS_ERROR_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_ERROR_TASK_CRASH_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_ERROR_ALL_FAILED_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_ERROR = exports.GAP_AUTO_FILL_SCHEDULE_PANEL_TITLE = exports.GAP_AUTO_FILL_RUN_TIME_COLUMN = exports.GAP_AUTO_FILL_RULES_PROCESSED_COLUMN = exports.GAP_AUTO_FILL_REFRESH_LABEL = exports.GAP_AUTO_FILL_ON_LABEL = exports.GAP_AUTO_FILL_OFF_LABEL = exports.GAP_AUTO_FILL_LOGS_VIEW_LOGS_BUTTON = exports.GAP_AUTO_FILL_LOGS_TITLE = exports.GAP_AUTO_FILL_LOGS_STATUS_COLUMN = exports.GAP_AUTO_FILL_LOGS_CALLOUT_TITLE = exports.GAP_AUTO_FILL_GAPS_SCHEDULED_COLUMN = exports.GAP_AUTO_FILL_EXPAND_ARIA_LABEL = exports.GAP_AUTO_FILL_COLLAPSE_ARIA_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GAP_AUTO_FILL_LOGS_TITLE = exports.GAP_AUTO_FILL_LOGS_TITLE = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.title', {
  defaultMessage: 'Gap fill scheduler logs'
});
const GAP_AUTO_FILL_RUN_TIME_COLUMN = exports.GAP_AUTO_FILL_RUN_TIME_COLUMN = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.runTimeColumn', {
  defaultMessage: 'Time'
});
const GAP_AUTO_FILL_GAPS_SCHEDULED_COLUMN = exports.GAP_AUTO_FILL_GAPS_SCHEDULED_COLUMN = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.gapsScheduledColumn', {
  defaultMessage: 'Gaps scheduled to be filled'
});
const GAP_AUTO_FILL_STATUS_PANEL_TITLE = exports.GAP_AUTO_FILL_STATUS_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusPanelTitle', {
  defaultMessage: 'Gap scheduler status'
});
const GAP_AUTO_FILL_RULES_PROCESSED_COLUMN = exports.GAP_AUTO_FILL_RULES_PROCESSED_COLUMN = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.rulesProcessedColumn', {
  defaultMessage: 'Rules processed'
});
const GAP_AUTO_FILL_ON_LABEL = exports.GAP_AUTO_FILL_ON_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.autoFillOnLabel', {
  defaultMessage: 'Auto fill on'
});
const GAP_AUTO_FILL_OFF_LABEL = exports.GAP_AUTO_FILL_OFF_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.autoFillOffLabel', {
  defaultMessage: 'Auto fill off'
});
const GAP_AUTO_FILL_EXPAND_ARIA_LABEL = exports.GAP_AUTO_FILL_EXPAND_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.expandRowAriaLabel', {
  defaultMessage: 'Expand row'
});
const GAP_AUTO_FILL_COLLAPSE_ARIA_LABEL = exports.GAP_AUTO_FILL_COLLAPSE_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.collapseRowAriaLabel', {
  defaultMessage: 'Collapse row'
});
const GAP_AUTO_FILL_REFRESH_LABEL = exports.GAP_AUTO_FILL_REFRESH_LABEL = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.refreshLabel', {
  defaultMessage: 'Refresh'
});
const GAP_AUTO_FILL_STATUS_FILTER_TITLE = exports.GAP_AUTO_FILL_STATUS_FILTER_TITLE = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusFilterTitle', {
  defaultMessage: 'Schedule status'
});
const GAP_AUTO_FILL_LOGS_STATUS_COLUMN = exports.GAP_AUTO_FILL_LOGS_STATUS_COLUMN = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.logsStatusColumn', {
  defaultMessage: 'Schedule status'
});
const GAP_AUTO_FILL_LOGS_VIEW_LOGS_BUTTON = exports.GAP_AUTO_FILL_LOGS_VIEW_LOGS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.viewLogsButton', {
  defaultMessage: 'View logs'
});
const GAP_AUTO_FILL_SCHEDULE_PANEL_TITLE = exports.GAP_AUTO_FILL_SCHEDULE_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.schedulePanelTitle', {
  defaultMessage: 'Gap scheduler schedule'
});
const GAP_AUTO_FILL_STATUS_SUCCESS = exports.GAP_AUTO_FILL_STATUS_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSuccess', {
  defaultMessage: 'Success'
});
const GAP_AUTO_FILL_STATUS_ERROR = exports.GAP_AUTO_FILL_STATUS_ERROR = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusError', {
  defaultMessage: 'Error'
});
const GAP_AUTO_FILL_STATUS_SKIPPED = exports.GAP_AUTO_FILL_STATUS_SKIPPED = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSkipped', {
  defaultMessage: 'Skipped'
});
const GAP_AUTO_FILL_LOGS_CALLOUT_TITLE = exports.GAP_AUTO_FILL_LOGS_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.calloutTitle', {
  defaultMessage: 'About the scheduler logs'
});
const GAP_AUTO_FILL_STATUS_NO_GAPS = exports.GAP_AUTO_FILL_STATUS_NO_GAPS = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusNoGaps', {
  defaultMessage: 'No gaps'
});

// Success tooltips
const GAP_AUTO_FILL_STATUS_SUCCESS_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SUCCESS_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSuccessTooltip', {
  defaultMessage: 'Gap fill tasks were scheduled successfully for processed rules.'
});

// Error tooltips
const GAP_AUTO_FILL_STATUS_ERROR_ALL_FAILED_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_ERROR_ALL_FAILED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusErrorAllFailedTooltip', {
  defaultMessage: 'Gap fill tasks could not be scheduled for rules.'
});
const getGapAutoFillStatusErrorSomeSucceededTooltip = successCount => _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusErrorSomeFailedTooltip', {
  defaultMessage: 'Gap fill tasks were successfully scheduled for {successCount} {successCount, plural, one {rule} other {rules}}. Tasks could not be scheduled for the other rules.',
  values: {
    successCount
  }
});
exports.getGapAutoFillStatusErrorSomeSucceededTooltip = getGapAutoFillStatusErrorSomeSucceededTooltip;
const GAP_AUTO_FILL_STATUS_ERROR_TASK_CRASH_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_ERROR_TASK_CRASH_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusErrorTaskCrashTooltip', {
  defaultMessage: 'An error caused the gap fill task to crash. For troubleshooting tips, refer to the documentation.'
});
const GAP_AUTO_FILL_STATUS_ERROR_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_ERROR_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusErrorTooltip', {
  defaultMessage: 'Gap fill tasks for some or all rules were not scheduled due to an error during task execution.'
});

// Skipped tooltips
const GAP_AUTO_FILL_STATUS_SKIPPED_NO_CAPACITY_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SKIPPED_NO_CAPACITY_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSkippedNoCapacityTooltip', {
  defaultMessage: 'Tasks could not be scheduled because the limit for scheduled gap fill tasks has been met.'
});
const GAP_AUTO_FILL_STATUS_SKIPPED_RULES_DISABLED_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SKIPPED_RULES_DISABLED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSkippedRulesDisabledTooltip', {
  defaultMessage: 'Disabled rules have unfilled gaps. Enable them to schedule gap fill tasks.'
});
const getGapAutoFillStatusSkippedSomeSucceededTooltip = successCount => _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSkippedSomeSucceededTooltip', {
  defaultMessage: 'Gap fill tasks for {successCount} {successCount, plural, one {rule} other {rules}} were successfully scheduled. Tasks for other rules were not scheduled because the task limit has been met.',
  values: {
    successCount
  }
});
exports.getGapAutoFillStatusSkippedSomeSucceededTooltip = getGapAutoFillStatusSkippedSomeSucceededTooltip;
const GAP_AUTO_FILL_STATUS_SKIPPED_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_SKIPPED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusSkippedTooltip', {
  defaultMessage: 'Gap fill tasks cannot be scheduled because the max limit of tasks has been met or some rules are disabled.'
});

// No gaps tooltip
const GAP_AUTO_FILL_STATUS_NO_GAPS_TOOLTIP = exports.GAP_AUTO_FILL_STATUS_NO_GAPS_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.gapAutoFillLogs.statusNoGapsTooltip', {
  defaultMessage: "Gaps in rule executions don't currently exist."
});