"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_EXCEPTION = exports.OPERATING_SYSTEM_WINDOWS_AND_MAC = exports.OPERATING_SYSTEM_WINDOWS = exports.OPERATING_SYSTEM_MAC = exports.OPERATING_SYSTEM_LINUX = exports.OPERATING_SYSTEM_LABEL = exports.MODAL_ERROR_ACCORDION_TEXT = exports.ERROR_FETCHING_REFERENCES_TITLE = exports.ERROR = exports.ENDPOINT_EXCEPTION = exports.COMMENT_EVENT = exports.CLEAR_EXCEPTIONS_LABEL = exports.CANCEL = exports.ADD_TO_CLIPBOARD = exports.ADD_EXCEPTION_FETCH_ERROR = exports.ADD_EXCEPTION_FETCH_404_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMENT_EVENT = exports.COMMENT_EVENT = _i18n.i18n.translate('xpack.securitySolution.exceptions.commentEventLabel', {
  defaultMessage: 'added a comment'
});
const OPERATING_SYSTEM_LABEL = exports.OPERATING_SYSTEM_LABEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemFullLabel', {
  defaultMessage: 'Operating System'
});
const ADD_TO_CLIPBOARD = exports.ADD_TO_CLIPBOARD = _i18n.i18n.translate('xpack.securitySolution.exceptions.viewer.addToClipboard', {
  defaultMessage: 'Comment'
});
const CLEAR_EXCEPTIONS_LABEL = exports.CLEAR_EXCEPTIONS_LABEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.clearExceptionsLabel', {
  defaultMessage: 'Remove Exception List'
});
const ADD_EXCEPTION_FETCH_404_ERROR = listId => _i18n.i18n.translate('xpack.securitySolution.exceptions.fetch404Error', {
  values: {
    listId
  },
  defaultMessage: 'The associated exception list ({listId}) no longer exists. Please remove the missing exception list to add additional exceptions to the detection rule.'
});
exports.ADD_EXCEPTION_FETCH_404_ERROR = ADD_EXCEPTION_FETCH_404_ERROR;
const ADD_EXCEPTION_FETCH_ERROR = exports.ADD_EXCEPTION_FETCH_ERROR = _i18n.i18n.translate('xpack.securitySolution.exceptions.fetchError', {
  defaultMessage: 'Error fetching exception list'
});
const ERROR = exports.ERROR = _i18n.i18n.translate('xpack.securitySolution.exceptions.errorLabel', {
  defaultMessage: 'Error'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.cancelLabel', {
  defaultMessage: 'Cancel'
});
const MODAL_ERROR_ACCORDION_TEXT = exports.MODAL_ERROR_ACCORDION_TEXT = _i18n.i18n.translate('xpack.securitySolution.exceptions.modalErrorAccordionText', {
  defaultMessage: 'Show rule reference information:'
});
const OPERATING_SYSTEM_WINDOWS = exports.OPERATING_SYSTEM_WINDOWS = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemWindows', {
  defaultMessage: 'Windows'
});
const OPERATING_SYSTEM_MAC = exports.OPERATING_SYSTEM_MAC = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemMac', {
  defaultMessage: 'macOS'
});
const OPERATING_SYSTEM_WINDOWS_AND_MAC = exports.OPERATING_SYSTEM_WINDOWS_AND_MAC = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemWindowsAndMac', {
  defaultMessage: 'Windows and macOS'
});
const OPERATING_SYSTEM_LINUX = exports.OPERATING_SYSTEM_LINUX = _i18n.i18n.translate('xpack.securitySolution.exceptions.operatingSystemLinux', {
  defaultMessage: 'Linux'
});
const ERROR_FETCHING_REFERENCES_TITLE = exports.ERROR_FETCHING_REFERENCES_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.fetchingReferencesErrorToastTitle', {
  defaultMessage: 'Error fetching exception references'
});
const RULE_EXCEPTION = exports.RULE_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.ruleException', {
  defaultMessage: 'rule exception'
});
const ENDPOINT_EXCEPTION = exports.ENDPOINT_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.endpointException', {
  defaultMessage: 'endpoint exception'
});