"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditExceptionFlyout = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _moment = _interopRequireDefault(require("moment"));
var _user_privileges = require("../../../../common/components/user_privileges");
var _utils = require("../../../../../common/detection_engine/utils");
var _item_meta_form = require("../flyout_components/item_meta_form");
var _linked_to_list = require("../flyout_components/linked_to_list");
var _linked_to_rule = require("../flyout_components/linked_to_rule");
var _alerts_actions = require("../flyout_components/alerts_actions");
var _item_conditions = require("../flyout_components/item_conditions");
var _use_exception_flyout_data = require("../../logic/use_exception_flyout_data");
var _use_close_alerts = require("../../logic/use_close_alerts");
var _use_find_references = require("../../logic/use_find_references");
var _utils2 = require("../flyout_components/utils");
var _item_comments = require("../item_comments");
var _reducer = require("./reducer");
var _use_edit_exception = require("./use_edit_exception");
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../utils/translations");
var _expire_time = require("../flyout_components/expire_time");
var _translations3 = require("../../../../management/common/translations");
var _artifact_confirm_modal = require("../../../../management/components/artifact_list_page/components/artifact_confirm_modal");
var _footer = require("../flyout_components/footer");
var _header = require("../flyout_components/header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/edit_exception_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutBodySection = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  ${() => (0, _styledComponents.css)`
    &.builder-section {
      overflow-y: scroll;
    }
  `}
`;
const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const EditExceptionFlyoutComponent = ({
  list,
  itemToEdit,
  rule,
  showAlertCloseOptions,
  openedFromListDetailPage,
  onCancel,
  onConfirm
}) => {
  var _itemToEdit$comments$;
  const selectedOs = (0, _react.useMemo)(() => itemToEdit.os_types, [itemToEdit]);
  const rules = (0, _react.useMemo)(() => rule != null ? [rule] : null, [rule]);
  const listType = (0, _react.useMemo)(() => list.type, [list]);
  const {
    isLoading,
    indexPatterns,
    getExtendedFields
  } = (0, _use_exception_flyout_data.useFetchIndexPatterns)(rules);
  const [isSubmitting, submitEditExceptionItems] = (0, _use_edit_exception.useEditExceptionItems)();
  const [isClosingAlerts, closeAlerts] = (0, _use_close_alerts.useCloseAlertsFromExceptions)();
  const {
    read: canReadRules
  } = (0, _user_privileges.useUserPrivileges)().rulesPrivileges;
  const [{
    exceptionItems,
    exceptionItemMeta: {
      name: exceptionItemName
    },
    newComment,
    commentErrorExists,
    bulkCloseAlerts,
    disableBulkClose,
    bulkCloseIndex,
    entryErrorExists,
    expireTime,
    expireErrorExists,
    wildcardWarningExists,
    partialCodeSignatureWarningExists
  }, dispatch] = (0, _react.useReducer)((0, _reducer.createExceptionItemsReducer)(), {
    exceptionItems: [itemToEdit],
    exceptionItemMeta: {
      name: itemToEdit.name
    },
    newComment: '',
    commentErrorExists: false,
    bulkCloseAlerts: false,
    disableBulkClose: true,
    bulkCloseIndex: undefined,
    entryErrorExists: false,
    expireTime: itemToEdit.expire_time !== undefined ? (0, _moment.default)(itemToEdit.expire_time) : undefined,
    expireErrorExists: false,
    wildcardWarningExists: false,
    partialCodeSignatureWarningExists: false
  });
  const allowLargeValueLists = (0, _react.useMemo)(() => {
    if (rule != null) {
      // We'll only block this when we know what rule we're dealing with.
      // When editing an item outside the context of a specific rule,
      // we won't block but should communicate to the user that large value lists
      // won't be applied to all rule types.
      return !(0, _utils.isEqlRule)(rule.type) && !(0, _utils.isThresholdRule)(rule.type) && !(0, _utils.isNewTermsRule)(rule.type);
    } else {
      return true;
    }
  }, [rule]);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(wildcardWarningExists);
  const [isLoadingReferences, referenceFetchError, ruleReferences, fetchReferences] = (0, _use_find_references.useFindExceptionListReferences)();
  (0, _react.useEffect)(() => {
    if (fetchReferences != null && canReadRules) {
      fetchReferences([{
        id: list.id,
        listId: list.list_id,
        namespaceType: list.namespace_type
      }]);
    }
  }, [list, fetchReferences, canReadRules]);

  /**
   * Reducer action dispatchers
   * */
  const setExceptionItemsToAdd = (0, _react.useCallback)(items => {
    dispatch({
      type: 'setWildcardWithWrongOperator',
      warningExists: (0, _securitysolutionListUtils.hasWrongOperatorWithWildcard)(items)
    });
    dispatch({
      type: 'setPartialCodeSignature',
      warningExists: (0, _securitysolutionListUtils.hasPartialCodeSignatureEntry)(items)
    });
    dispatch({
      type: 'setExceptionItems',
      items
    });
  }, [dispatch]);
  const setExceptionItemMeta = (0, _react.useCallback)(value => {
    dispatch({
      type: 'setExceptionItemMeta',
      value
    });
  }, [dispatch]);
  const setComment = (0, _react.useCallback)(comment => {
    dispatch({
      type: 'setComment',
      comment
    });
  }, [dispatch]);
  const setCommentError = (0, _react.useCallback)(errorExists => {
    dispatch({
      type: 'setCommentError',
      errorExists
    });
  }, [dispatch]);
  const setBulkCloseAlerts = (0, _react.useCallback)(bulkClose => {
    dispatch({
      type: 'setBulkCloseAlerts',
      bulkClose
    });
  }, [dispatch]);
  const setDisableBulkCloseAlerts = (0, _react.useCallback)(disableBulkCloseAlerts => {
    dispatch({
      type: 'setDisableBulkCloseAlerts',
      disableBulkCloseAlerts
    });
  }, [dispatch]);
  const setBulkCloseIndex = (0, _react.useCallback)(index => {
    dispatch({
      type: 'setBulkCloseIndex',
      bulkCloseIndex: index
    });
  }, [dispatch]);
  const setConditionsValidationError = (0, _react.useCallback)(errorExists => {
    dispatch({
      type: 'setConditionValidationErrorExists',
      errorExists
    });
  }, [dispatch]);
  const setExpireTime = (0, _react.useCallback)(exceptionExpireTime => {
    dispatch({
      type: 'setExpireTime',
      expireTime: exceptionExpireTime
    });
  }, [dispatch]);
  const setExpireError = (0, _react.useCallback)(errorExists => {
    dispatch({
      type: 'setExpireError',
      errorExists
    });
  }, [dispatch]);
  const handleCloseFlyout = (0, _react.useCallback)(() => {
    onCancel(false);
  }, [onCancel]);
  const areItemsReadyForUpdate = (0, _react.useCallback)(items => {
    return items.every(item => _securitysolutionIoTsListTypes.updateExceptionListItemSchema.is(item));
  }, []);
  const handleSubmitException = (0, _react.useCallback)(async () => {
    if (submitEditExceptionItems == null) return;
    try {
      const items = (0, _utils2.enrichExceptionItemsForUpdate)({
        itemName: exceptionItemName,
        commentToAdd: newComment,
        listType,
        selectedOs: itemToEdit.os_types,
        expireTime,
        items: exceptionItems
      });
      if (areItemsReadyForUpdate(items)) {
        await submitEditExceptionItems({
          itemsToUpdate: items
        });
        const ruleDefaultRule = rule != null ? [rule.rule_id] : [];
        const referencedRules = ruleReferences != null ? ruleReferences[list.list_id].referenced_rules.map(({
          rule_id: ruleId
        }) => ruleId) : [];
        const ruleIdsForBulkClose = listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT ? ruleDefaultRule : referencedRules;
        if (closeAlerts != null && !(0, _fp.isEmpty)(ruleIdsForBulkClose) && bulkCloseAlerts) {
          await closeAlerts(ruleIdsForBulkClose, items, undefined, bulkCloseIndex);
        }
        onConfirm(true);
      }
    } catch (e) {
      onCancel(false);
    }
  }, [submitEditExceptionItems, exceptionItemName, newComment, listType, itemToEdit.os_types, exceptionItems, areItemsReadyForUpdate, rule, ruleReferences, list.list_id, closeAlerts, bulkCloseAlerts, onConfirm, bulkCloseIndex, onCancel, expireTime]);
  const handleOnSubmit = (0, _react.useCallback)(() => {
    if (wildcardWarningExists) {
      setShowConfirmModal(true);
    } else {
      return handleSubmitException();
    }
  }, [wildcardWarningExists, handleSubmitException]);
  const isSubmitButtonDisabled = (0, _react.useMemo)(() => isSubmitting || isClosingAlerts || exceptionItems.every(item => item.entries.length === 0) || isLoading || entryErrorExists || expireErrorExists || commentErrorExists, [isLoading, entryErrorExists, exceptionItems, isSubmitting, isClosingAlerts, expireErrorExists, commentErrorExists]);
  const exceptionFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'exceptionFlyoutTitle'
  });
  const confirmModal = (0, _react.useMemo)(() => {
    const {
      title,
      body,
      confirmButton,
      cancelButton
    } = (0, _translations3.CONFIRM_WARNING_MODAL_LABELS)(listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? _translations2.ENDPOINT_EXCEPTION : _translations2.RULE_EXCEPTION);
    return /*#__PURE__*/_react.default.createElement(_artifact_confirm_modal.ArtifactConfirmModal, {
      title: title,
      body: body,
      confirmButton: confirmButton,
      cancelButton: cancelButton,
      onSuccess: handleSubmitException,
      onCancel: () => setShowConfirmModal(false),
      "data-test-subj": "artifactConfirmModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 7
      }
    });
  }, [listType, handleSubmitException]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "l",
    onClose: handleCloseFlyout,
    "data-test-subj": "editExceptionFlyout",
    "aria-labelledby": exceptionFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header.ExceptionFlyoutHeader, {
    isEdit: true,
    listType: listType,
    titleId: exceptionFlyoutTitleId,
    dataTestSubjId: 'exceptionFlyoutTitle',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(FlyoutBodySection, {
    className: "builder-section",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 7
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "loadingEditExceptionFlyout",
    lines: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_item_meta_form.ExceptionsFlyoutMeta, {
    exceptionItemName: exceptionItemName,
    onChange: setExceptionItemMeta,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_item_conditions.ExceptionsConditions, {
    exceptionItemName: exceptionItemName,
    allowLargeValueLists: allowLargeValueLists,
    exceptionListItems: [itemToEdit],
    exceptionListType: listType,
    indexPatterns: indexPatterns,
    rules: rules,
    selectedOs: selectedOs,
    showOsTypeOptions: listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT,
    isEdit: true,
    onExceptionItemAdd: setExceptionItemsToAdd,
    onSetErrorExists: setConditionsValidationError,
    getExtendedFields: getExtendedFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 9
    }
  }), wildcardWarningExists && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.WildCardWithWrongOperatorCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 35
    }
  }), partialCodeSignatureWarningExists && /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.PartialCodeSignatureCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 47
    }
  }), !openedFromListDetailPage && listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_linked_to_list.ExceptionsLinkedToLists, {
    isLoadingReferences: isLoadingReferences,
    errorFetchingReferences: referenceFetchError,
    listAndReferences: ruleReferences != null ? [ruleReferences[list.list_id]] : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 13
    }
  })), !openedFromListDetailPage && listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT && rule != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_linked_to_rule.ExceptionsLinkedToRule, {
    rule: rule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_item_comments.ExceptionItemComments, {
    accordionTitle: /*#__PURE__*/_react.default.createElement(SectionHeader, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 457,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 458,
        columnNumber: 15
      }
    }, i18n.COMMENTS_SECTION_TITLE((_itemToEdit$comments$ = itemToEdit.comments.length) !== null && _itemToEdit$comments$ !== void 0 ? _itemToEdit$comments$ : 0))),
    exceptionItemComments: itemToEdit.comments,
    newCommentValue: newComment,
    newCommentOnChange: setComment,
    setCommentError: setCommentError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 455,
      columnNumber: 9
    }
  }), listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_expire_time.ExceptionsExpireTime, {
    expireTime: expireTime,
    setExpireTime: setExpireTime,
    setExpireError: setExpireError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  })), showAlertCloseOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_alerts_actions.ExceptionItemsFlyoutAlertsActions, {
    exceptionListType: listType,
    shouldBulkCloseAlert: bulkCloseAlerts,
    disableBulkClose: disableBulkClose,
    exceptionListItems: exceptionItems,
    onDisableBulkClose: setDisableBulkCloseAlerts,
    onUpdateBulkCloseIndex: setBulkCloseIndex,
    onBulkCloseCheckboxChange: setBulkCloseAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 479,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_footer.ExceptionFlyoutFooter, {
    isEdit: true,
    listType: listType,
    isSubmitButtonDisabled: isSubmitButtonDisabled,
    cancelButtonDataTestSubjId: 'cancelExceptionEditButton',
    submitButtonDataTestSubjId: 'editExceptionConfirmButton',
    handleOnSubmit: handleOnSubmit,
    handleCloseFlyout: handleCloseFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 7
    }
  }), showConfirmModal && confirmModal);
};
const EditExceptionFlyout = exports.EditExceptionFlyout = /*#__PURE__*/_react.default.memo(EditExceptionFlyoutComponent);
EditExceptionFlyout.displayName = 'EditExceptionFlyout';