"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUBMIT_ERROR_TITLE = exports.SUBMIT_ERROR_DISMISS_MESSAGE = exports.SUBMIT_ERROR_DISMISS_BUTTON = exports.COMMENTS_SECTION_TITLE = exports.CANCEL = exports.ADD_RULE_EXCEPTION_SUCCESS_TITLE = exports.ADD_RULE_EXCEPTION_SUCCESS_TEXT = exports.ADD_RULE_EXCEPTION_FROM_ALERT_COMMENT = exports.ADD_EXCEPTION_SUCCESS_DETAILS = exports.ADD_EXCEPTION_SUCCESS = exports.ADD_ENDPOINT_EXCEPTION_SUCCESS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.cancel', {
  defaultMessage: 'Cancel'
});
const SUBMIT_ERROR_TITLE = exports.SUBMIT_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.submitError.title', {
  defaultMessage: 'An error occured submitting exception'
});
const SUBMIT_ERROR_DISMISS_BUTTON = exports.SUBMIT_ERROR_DISMISS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.submitError.dismissButton', {
  defaultMessage: 'Dismiss'
});
const SUBMIT_ERROR_DISMISS_MESSAGE = exports.SUBMIT_ERROR_DISMISS_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.submitError.message', {
  defaultMessage: 'View toast for error details.'
});
const ADD_EXCEPTION_SUCCESS = exports.ADD_EXCEPTION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addException.success', {
  defaultMessage: 'Rule exception added to shared exception list'
});
const ADD_ENDPOINT_EXCEPTION_SUCCESS = exports.ADD_ENDPOINT_EXCEPTION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addEndpointException.success', {
  defaultMessage: 'Endpoint exception added to shared exception list'
});
const ADD_EXCEPTION_SUCCESS_DETAILS = (listType, listNames) => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addExceptionFlyout.successDetails', {
  values: {
    listNames,
    listType
  },
  defaultMessage: '{listType} exception has been added to shared lists: {listNames}.'
});
exports.ADD_EXCEPTION_SUCCESS_DETAILS = ADD_EXCEPTION_SUCCESS_DETAILS;
const ADD_RULE_EXCEPTION_SUCCESS_TITLE = exports.ADD_RULE_EXCEPTION_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addExceptionFlyout.addRuleExceptionToastSuccessTitle', {
  defaultMessage: 'Rule exception added'
});
const ADD_RULE_EXCEPTION_SUCCESS_TEXT = ruleName => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addExceptionFlyout.addRuleExceptionToastSuccessText', {
  values: {
    ruleName
  },
  defaultMessage: 'Exception has been added to rules - {ruleName}.'
});
exports.ADD_RULE_EXCEPTION_SUCCESS_TEXT = ADD_RULE_EXCEPTION_SUCCESS_TEXT;
const COMMENTS_SECTION_TITLE = comments => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addExceptionFlyout.commentsTitle', {
  values: {
    comments
  },
  defaultMessage: 'Add comments ({comments})'
});
exports.COMMENTS_SECTION_TITLE = COMMENTS_SECTION_TITLE;
const ADD_RULE_EXCEPTION_FROM_ALERT_COMMENT = alertId => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.addExceptionFlyout.addRuleExceptionFromAlertComment', {
  values: {
    alertId
  },
  defaultMessage: 'Exception conditions are pre-filled with relevant data from an alert with the alert id (_id): {alertId}.'
});
exports.ADD_RULE_EXCEPTION_FROM_ALERT_COMMENT = ADD_RULE_EXCEPTION_FROM_ALERT_COMMENT;