"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeEmptyRequiredFields = exports.isRuleAction = exports.getTimeTypeValue = exports.getStepDataDataSource = exports.formatScheduleStepData = exports.formatRule = exports.formatPreviewRule = exports.formatDefineStepData = exports.formatActionsStepData = exports.formatAboutStepData = exports.filterRuleFieldsForType = exports.filterOutEmptySeverityMappingItems = exports.filterOutEmptyRiskScoreMappingItems = exports.filterOutEmptyRelatedIntegrations = exports.filterEmptyThreats = void 0;
var _fp = require("lodash/fp");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _lodash = require("lodash");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _time_duration = require("@kbn/securitysolution-utils/time_duration");
var _utility_types = require("../../../../../common/utility_types");
var _transform_actions = require("../../../../../common/detection_engine/transform_actions");
var _types = require("../../../common/types");
var _step_rule_actions = require("../../../rule_creation/components/step_rule_actions");
var _constants = require("../../../../../common/detection_engine/constants");
var _alert_suppression_edit = require("../../../rule_creation/components/alert_suppression_edit");
var _threshold_alert_suppression_edit = require("../../../rule_creation/components/threshold_alert_suppression_edit");
var _date_math = require("../../../../common/utils/date_math");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

const getTimeTypeValue = time => {
  const timeObj = {
    unit: 'ms',
    value: 0
  };
  const filterTimeVal = time.match(/\d+/g);
  const filterTimeType = time.match(/[a-zA-Z]+/g);
  if (!(0, _fp.isEmpty)(filterTimeVal) && filterTimeVal != null && !isNaN(Number(filterTimeVal[0]))) {
    timeObj.value = Number(filterTimeVal[0]);
  }
  if (!(0, _fp.isEmpty)(filterTimeType) && filterTimeType != null && ['s', 'm', 'h', 'd'].includes(filterTimeType[0])) {
    timeObj.unit = filterTimeType[0];
  }
  return timeObj;
};
exports.getTimeTypeValue = getTimeTypeValue;
const isMlFields = fields => (0, _fp.has)('anomalyThreshold', fields);
const isThresholdFields = fields => (0, _fp.has)('threshold', fields);
const isThreatMatchFields = fields => (0, _fp.has)('threatIndex', fields);
const isNewTermsFields = fields => (0, _fp.has)('newTermsFields', fields);
const isEqlFields = fields => (0, _fp.has)('eqlOptions', fields);
const isEsqlFields = fields => (0, _fp.get)('queryBar.query.language', fields) === 'esql';
const filterRuleFieldsForType = (fields, type) => {
  switch (type) {
    case 'machine_learning':
      return (0, _lodash.omit)(fields, ['index', 'queryBar', 'threshold', 'threatIndex', 'threatQueryBar', 'threatMapping', 'eqlOptions', 'newTermsFields', 'historyWindowSize']);
    case 'threshold':
      return (0, _lodash.omit)(fields, ['anomalyThreshold', 'machineLearningJobId', 'threatIndex', 'threatQueryBar', 'threatMapping', 'eqlOptions', 'newTermsFields', 'historyWindowSize']);
    case 'threat_match':
      return (0, _lodash.omit)(fields, ['anomalyThreshold', 'machineLearningJobId', 'threshold', 'eqlOptions', 'newTermsFields', 'historyWindowSize']);
    case 'query':
    case 'saved_query':
      return (0, _lodash.omit)(fields, ['anomalyThreshold', 'machineLearningJobId', 'threshold', 'threatIndex', 'threatQueryBar', 'threatMapping', 'eqlOptions', 'newTermsFields', 'historyWindowSize']);
    case 'eql':
      return (0, _lodash.omit)(fields, ['anomalyThreshold', 'machineLearningJobId', 'threshold', 'threatIndex', 'threatQueryBar', 'threatMapping', 'newTermsFields', 'historyWindowSize']);
    case 'new_terms':
      return (0, _lodash.omit)(fields, ['anomalyThreshold', 'machineLearningJobId', 'threshold', 'threatIndex', 'threatQueryBar', 'threatMapping', 'eqlOptions']);
    case 'esql':
      return (0, _lodash.omit)(fields, ['anomalyThreshold', 'machineLearningJobId', 'threshold', 'threatIndex', 'threatQueryBar', 'threatMapping', 'newTermsFields', 'historyWindowSize', 'eqlOptions', 'index', 'dataViewId']);
  }
  (0, _utility_types.assertUnreachable)(type);
};
exports.filterRuleFieldsForType = filterRuleFieldsForType;
function trimThreatsWithNoName(filterable) {
  return filterable.filter(item => item.name !== 'none');
}

/**
 * Filter out unfilled/empty threat, technique, and subtechnique fields based on if their name is `none`
 */
const filterEmptyThreats = threats => {
  return threats.filter(singleThreat => singleThreat.tactic.name !== 'none').map(threat => {
    var _threat$technique;
    return {
      ...threat,
      technique: trimThreatsWithNoName((_threat$technique = threat.technique) !== null && _threat$technique !== void 0 ? _threat$technique : []).map(technique => {
        return {
          ...technique,
          subtechnique: technique.subtechnique != null ? trimThreatsWithNoName(technique.subtechnique) : undefined
        };
      })
    };
  });
};

/**
 * remove unused data source.
 * Ex: rule is using a data view so we should not
 * write an index property on the rule form.
 * @param defineStepData
 * @returns DefineStepRule
 */
exports.filterEmptyThreats = filterEmptyThreats;
const getStepDataDataSource = defineStepData => {
  const copiedStepData = {
    ...defineStepData
  };
  if (defineStepData.dataSourceType === _types.DataSourceType.DataView) {
    return (0, _lodash.omit)(copiedStepData, ['index', 'dataSourceType']);
  } else if (defineStepData.dataSourceType === _types.DataSourceType.IndexPatterns) {
    return (0, _lodash.omit)(copiedStepData, ['dataViewId', 'dataSourceType']);
  }
  return copiedStepData;
};

/**
 * Strips away form rows that were not filled out by the user
 */
exports.getStepDataDataSource = getStepDataDataSource;
const removeEmptyRequiredFields = requiredFields => requiredFields.filter(field => field.name !== '' && field.type !== '');
exports.removeEmptyRequiredFields = removeEmptyRequiredFields;
const formatDefineStepData = defineStepData => {
  var _ruleFields$ALERT_SUP, _defineStepData$requi, _ruleFields$queryBar, _ruleFields$queryBar2, _ruleFields$queryBar3, _ruleFields$queryBar4, _ruleFields$queryBar5, _ruleFields$queryBar$, _ruleFields$queryBar6, _ruleFields$threshold, _ruleFields$threshold2, _parseInt, _ruleFields$threshold3, _ruleFields$threshold4, _ruleFields$threshold5, _ruleFields$queryBar7, _ruleFields$queryBar8, _ruleFields$queryBar9, _ruleFields$queryBar10, _ruleFields$queryBar11, _ruleFields$queryBar$2, _ruleFields$queryBar12, _ruleFields$threatQue, _ruleFields$threatQue2, _ruleFields$threatQue3, _ruleFields$threatQue4, _ruleFields$threatQue5, _ruleFields$queryBar13, _ruleFields$queryBar14, _ruleFields$queryBar15, _ruleFields$queryBar16, _ruleFields$queryBar17, _ruleFields$queryBar$3, _ruleFields$queryBar18, _ruleFields$eqlOption, _ruleFields$eqlOption2, _ruleFields$eqlOption3, _ruleFields$queryBar19, _ruleFields$queryBar20, _ruleFields$queryBar21, _ruleFields$queryBar22, _ruleFields$queryBar23, _ruleFields$queryBar24, _ruleFields$queryBar25, _ruleFields$queryBar26, _ruleFields$queryBar27, _ruleFields$queryBar28, _ruleFields$queryBar29, _ruleFields$queryBar30, _ruleFields$queryBar31, _ruleFields$queryBar32, _ruleFields$queryBar33;
  const stepData = getStepDataDataSource(defineStepData);
  const ruleFields = filterRuleFieldsForType(stepData, stepData.ruleType);
  const {
    ruleType,
    timeline
  } = ruleFields;
  const baseFields = {
    type: ruleType,
    related_integrations: defineStepData.relatedIntegrations ? filterOutEmptyRelatedIntegrations(defineStepData.relatedIntegrations) : undefined,
    ...(timeline.id != null && timeline.title != null && {
      timeline_id: timeline.id,
      timeline_title: timeline.title
    })
  };

  // Threshold rule won't contain alert suppression fields
  const alertSuppressionFields = ((_ruleFields$ALERT_SUP = ruleFields[_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME]) === null || _ruleFields$ALERT_SUP === void 0 ? void 0 : _ruleFields$ALERT_SUP.length) > 0 ? {
    alert_suppression: {
      group_by: ruleFields[_alert_suppression_edit.ALERT_SUPPRESSION_FIELDS_FIELD_NAME],
      duration: ruleFields[_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME] === _types.AlertSuppressionDurationType.PerTimePeriod ? ruleFields[_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME] : undefined,
      missing_fields_strategy: ruleFields[_alert_suppression_edit.ALERT_SUPPRESSION_MISSING_FIELDS_FIELD_NAME] || _constants.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY
    }
  } : {};
  const requiredFields = removeEmptyRequiredFields((_defineStepData$requi = defineStepData.requiredFields) !== null && _defineStepData$requi !== void 0 ? _defineStepData$requi : []);
  const typeFields = isMlFields(ruleFields) ? {
    anomaly_threshold: ruleFields.anomalyThreshold,
    machine_learning_job_id: ruleFields.machineLearningJobId,
    ...alertSuppressionFields
  } : isThresholdFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar = ruleFields.queryBar) === null || _ruleFields$queryBar === void 0 ? void 0 : _ruleFields$queryBar.filters,
    language: (_ruleFields$queryBar2 = ruleFields.queryBar) === null || _ruleFields$queryBar2 === void 0 ? void 0 : (_ruleFields$queryBar3 = _ruleFields$queryBar2.query) === null || _ruleFields$queryBar3 === void 0 ? void 0 : _ruleFields$queryBar3.language,
    query: (_ruleFields$queryBar4 = ruleFields.queryBar) === null || _ruleFields$queryBar4 === void 0 ? void 0 : (_ruleFields$queryBar5 = _ruleFields$queryBar4.query) === null || _ruleFields$queryBar5 === void 0 ? void 0 : _ruleFields$queryBar5.query,
    saved_id: (_ruleFields$queryBar$ = (_ruleFields$queryBar6 = ruleFields.queryBar) === null || _ruleFields$queryBar6 === void 0 ? void 0 : _ruleFields$queryBar6.saved_id) !== null && _ruleFields$queryBar$ !== void 0 ? _ruleFields$queryBar$ : undefined,
    required_fields: requiredFields,
    ...(ruleType === 'threshold' && {
      threshold: {
        field: (_ruleFields$threshold = (_ruleFields$threshold2 = ruleFields.threshold) === null || _ruleFields$threshold2 === void 0 ? void 0 : _ruleFields$threshold2.field) !== null && _ruleFields$threshold !== void 0 ? _ruleFields$threshold : [],
        value: (_parseInt = parseInt((_ruleFields$threshold3 = ruleFields.threshold) === null || _ruleFields$threshold3 === void 0 ? void 0 : _ruleFields$threshold3.value, 10)) !== null && _parseInt !== void 0 ? _parseInt : 0,
        cardinality: !(0, _fp.isEmpty)((_ruleFields$threshold4 = ruleFields.threshold.cardinality) === null || _ruleFields$threshold4 === void 0 ? void 0 : _ruleFields$threshold4.field) && ((_ruleFields$threshold5 = ruleFields.threshold.cardinality) === null || _ruleFields$threshold5 === void 0 ? void 0 : _ruleFields$threshold5.value) != null ? [{
          field: ruleFields.threshold.cardinality.field[0],
          value: parseInt(ruleFields.threshold.cardinality.value, 10)
        }] : []
      },
      ...(ruleFields[_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED] && {
        alert_suppression: {
          duration: ruleFields[_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]
        }
      })
    })
  } : isThreatMatchFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar7 = ruleFields.queryBar) === null || _ruleFields$queryBar7 === void 0 ? void 0 : _ruleFields$queryBar7.filters,
    language: (_ruleFields$queryBar8 = ruleFields.queryBar) === null || _ruleFields$queryBar8 === void 0 ? void 0 : (_ruleFields$queryBar9 = _ruleFields$queryBar8.query) === null || _ruleFields$queryBar9 === void 0 ? void 0 : _ruleFields$queryBar9.language,
    query: (_ruleFields$queryBar10 = ruleFields.queryBar) === null || _ruleFields$queryBar10 === void 0 ? void 0 : (_ruleFields$queryBar11 = _ruleFields$queryBar10.query) === null || _ruleFields$queryBar11 === void 0 ? void 0 : _ruleFields$queryBar11.query,
    saved_id: (_ruleFields$queryBar$2 = (_ruleFields$queryBar12 = ruleFields.queryBar) === null || _ruleFields$queryBar12 === void 0 ? void 0 : _ruleFields$queryBar12.saved_id) !== null && _ruleFields$queryBar$2 !== void 0 ? _ruleFields$queryBar$2 : undefined,
    required_fields: requiredFields,
    threat_index: ruleFields.threatIndex,
    threat_query: (_ruleFields$threatQue = ruleFields.threatQueryBar) === null || _ruleFields$threatQue === void 0 ? void 0 : (_ruleFields$threatQue2 = _ruleFields$threatQue.query) === null || _ruleFields$threatQue2 === void 0 ? void 0 : _ruleFields$threatQue2.query,
    threat_filters: (_ruleFields$threatQue3 = ruleFields.threatQueryBar) === null || _ruleFields$threatQue3 === void 0 ? void 0 : _ruleFields$threatQue3.filters,
    threat_mapping: ruleFields.threatMapping,
    threat_language: (_ruleFields$threatQue4 = ruleFields.threatQueryBar) === null || _ruleFields$threatQue4 === void 0 ? void 0 : (_ruleFields$threatQue5 = _ruleFields$threatQue4.query) === null || _ruleFields$threatQue5 === void 0 ? void 0 : _ruleFields$threatQue5.language,
    ...alertSuppressionFields
  } : isEqlFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar13 = ruleFields.queryBar) === null || _ruleFields$queryBar13 === void 0 ? void 0 : _ruleFields$queryBar13.filters,
    language: (_ruleFields$queryBar14 = ruleFields.queryBar) === null || _ruleFields$queryBar14 === void 0 ? void 0 : (_ruleFields$queryBar15 = _ruleFields$queryBar14.query) === null || _ruleFields$queryBar15 === void 0 ? void 0 : _ruleFields$queryBar15.language,
    query: (_ruleFields$queryBar16 = ruleFields.queryBar) === null || _ruleFields$queryBar16 === void 0 ? void 0 : (_ruleFields$queryBar17 = _ruleFields$queryBar16.query) === null || _ruleFields$queryBar17 === void 0 ? void 0 : _ruleFields$queryBar17.query,
    saved_id: (_ruleFields$queryBar$3 = (_ruleFields$queryBar18 = ruleFields.queryBar) === null || _ruleFields$queryBar18 === void 0 ? void 0 : _ruleFields$queryBar18.saved_id) !== null && _ruleFields$queryBar$3 !== void 0 ? _ruleFields$queryBar$3 : undefined,
    required_fields: requiredFields,
    timestamp_field: (_ruleFields$eqlOption = ruleFields.eqlOptions) === null || _ruleFields$eqlOption === void 0 ? void 0 : _ruleFields$eqlOption.timestampField,
    event_category_override: (_ruleFields$eqlOption2 = ruleFields.eqlOptions) === null || _ruleFields$eqlOption2 === void 0 ? void 0 : _ruleFields$eqlOption2.eventCategoryField,
    tiebreaker_field: (_ruleFields$eqlOption3 = ruleFields.eqlOptions) === null || _ruleFields$eqlOption3 === void 0 ? void 0 : _ruleFields$eqlOption3.tiebreakerField,
    ...alertSuppressionFields
  } : isNewTermsFields(ruleFields) ? {
    index: ruleFields.index,
    filters: (_ruleFields$queryBar19 = ruleFields.queryBar) === null || _ruleFields$queryBar19 === void 0 ? void 0 : _ruleFields$queryBar19.filters,
    language: (_ruleFields$queryBar20 = ruleFields.queryBar) === null || _ruleFields$queryBar20 === void 0 ? void 0 : (_ruleFields$queryBar21 = _ruleFields$queryBar20.query) === null || _ruleFields$queryBar21 === void 0 ? void 0 : _ruleFields$queryBar21.language,
    query: (_ruleFields$queryBar22 = ruleFields.queryBar) === null || _ruleFields$queryBar22 === void 0 ? void 0 : (_ruleFields$queryBar23 = _ruleFields$queryBar22.query) === null || _ruleFields$queryBar23 === void 0 ? void 0 : _ruleFields$queryBar23.query,
    required_fields: requiredFields,
    new_terms_fields: ruleFields.newTermsFields,
    history_window_start: (0, _date_math.convertDurationToDateMath)(ruleFields.historyWindowSize),
    ...alertSuppressionFields
  } : isEsqlFields(ruleFields) && !('index' in ruleFields) ? {
    language: (_ruleFields$queryBar24 = ruleFields.queryBar) === null || _ruleFields$queryBar24 === void 0 ? void 0 : (_ruleFields$queryBar25 = _ruleFields$queryBar24.query) === null || _ruleFields$queryBar25 === void 0 ? void 0 : _ruleFields$queryBar25.language,
    query: (_ruleFields$queryBar26 = ruleFields.queryBar) === null || _ruleFields$queryBar26 === void 0 ? void 0 : (_ruleFields$queryBar27 = _ruleFields$queryBar26.query) === null || _ruleFields$queryBar27 === void 0 ? void 0 : _ruleFields$queryBar27.query,
    required_fields: requiredFields,
    ...alertSuppressionFields
  } : {
    ...alertSuppressionFields,
    index: ruleFields.index,
    filters: (_ruleFields$queryBar28 = ruleFields.queryBar) === null || _ruleFields$queryBar28 === void 0 ? void 0 : _ruleFields$queryBar28.filters,
    language: (_ruleFields$queryBar29 = ruleFields.queryBar) === null || _ruleFields$queryBar29 === void 0 ? void 0 : (_ruleFields$queryBar30 = _ruleFields$queryBar29.query) === null || _ruleFields$queryBar30 === void 0 ? void 0 : _ruleFields$queryBar30.language,
    query: (_ruleFields$queryBar31 = ruleFields.queryBar) === null || _ruleFields$queryBar31 === void 0 ? void 0 : (_ruleFields$queryBar32 = _ruleFields$queryBar31.query) === null || _ruleFields$queryBar32 === void 0 ? void 0 : _ruleFields$queryBar32.query,
    saved_id: undefined,
    required_fields: requiredFields,
    type: 'query',
    // rule only be updated as saved_query type if it has saved_id and shouldLoadQueryDynamically checkbox checked
    ...(['query', 'saved_query'].includes(ruleType) && ((_ruleFields$queryBar33 = ruleFields.queryBar) === null || _ruleFields$queryBar33 === void 0 ? void 0 : _ruleFields$queryBar33.saved_id) && ruleFields.shouldLoadQueryDynamically && {
      type: 'saved_query',
      query: undefined,
      filters: undefined,
      saved_id: ruleFields.queryBar.saved_id
    })
  };
  return {
    ...baseFields,
    ...typeFields,
    ...('dataViewId' in ruleFields ? {
      data_view_id: ruleFields.dataViewId
    } : {})
  };
};
exports.formatDefineStepData = formatDefineStepData;
const formatScheduleStepData = scheduleData => {
  var _formatScheduleData$i, _formatScheduleData$f;
  const {
    ...formatScheduleData
  } = scheduleData;
  const interval = _time_duration.TimeDuration.parse((_formatScheduleData$i = formatScheduleData.interval) !== null && _formatScheduleData$i !== void 0 ? _formatScheduleData$i : '');
  const lookBack = _time_duration.TimeDuration.parse((_formatScheduleData$f = formatScheduleData.from) !== null && _formatScheduleData$f !== void 0 ? _formatScheduleData$f : '');
  if (interval !== undefined && lookBack !== undefined) {
    const fromOffset = _time_duration.TimeDuration.fromMilliseconds(interval.toMilliseconds() + lookBack.toMilliseconds()).toString();
    formatScheduleData.from = `now-${fromOffset}`;
    formatScheduleData.to = 'now';
  }
  return formatScheduleData;
};
exports.formatScheduleStepData = formatScheduleStepData;
const formatAboutStepData = (aboutStepData, exceptionsList) => {
  const {
    author,
    falsePositives,
    investigationFields,
    references,
    riskScore,
    severity,
    threat,
    isAssociatedToEndpointList,
    isBuildingBlock,
    maxSignals,
    note,
    ruleNameOverride,
    threatIndicatorPath,
    timestampOverride,
    timestampOverrideFallbackDisabled,
    ...rest
  } = aboutStepData;
  const detectionExceptionLists = exceptionsList != null ? exceptionsList.filter(list => list.type !== 'endpoint') : [];
  const isinvestigationFieldsEmpty = investigationFields.every(item => (0, _fp.isEmpty)(item.trim()));
  const resp = {
    author: author.filter(item => !(0, _fp.isEmpty)(item)),
    ...(isBuildingBlock ? {
      building_block_type: 'default'
    } : {}),
    ...(isAssociatedToEndpointList ? {
      exceptions_list: [{
        id: _securitysolutionListConstants.ENDPOINT_LIST_ID,
        list_id: _securitysolutionListConstants.ENDPOINT_LIST_ID,
        namespace_type: 'agnostic',
        type: 'endpoint'
      }, ...detectionExceptionLists]
    } : exceptionsList != null ? {
      exceptions_list: [...detectionExceptionLists]
    } : {}),
    false_positives: falsePositives.filter(item => !(0, _fp.isEmpty)(item)),
    references: references.filter(item => !(0, _fp.isEmpty)(item)),
    investigation_fields: isinvestigationFieldsEmpty ? undefined : {
      field_names: investigationFields
    },
    risk_score: riskScore.value,
    risk_score_mapping: riskScore.isMappingChecked ? filterOutEmptyRiskScoreMappingItems(riskScore.mapping) : [],
    rule_name_override: ruleNameOverride !== '' ? ruleNameOverride : undefined,
    severity: severity.value,
    severity_mapping: severity.isMappingChecked ? filterOutEmptySeverityMappingItems(severity.mapping) : [],
    threat: filterEmptyThreats(threat).map(singleThreat => ({
      ...singleThreat,
      framework: 'MITRE ATT&CK'
    })),
    threat_indicator_path: threatIndicatorPath,
    timestamp_override: timestampOverride !== '' ? timestampOverride : undefined,
    timestamp_override_fallback_disabled: timestampOverrideFallbackDisabled,
    ...(!(0, _fp.isEmpty)(note) ? {
      note
    } : {}),
    max_signals: Number.isSafeInteger(maxSignals) ? maxSignals : undefined,
    ...rest
  };
  return resp;
};
exports.formatAboutStepData = formatAboutStepData;
const filterOutEmptyRiskScoreMappingItems = riskScoreMapping => riskScoreMapping.filter(m => m.field != null && m.field !== '');
exports.filterOutEmptyRiskScoreMappingItems = filterOutEmptyRiskScoreMappingItems;
const filterOutEmptySeverityMappingItems = severityMapping => severityMapping.filter(m => m.field != null && m.field !== '' && m.value != null);
exports.filterOutEmptySeverityMappingItems = filterOutEmptySeverityMappingItems;
const filterOutEmptyRelatedIntegrations = relatedIntegrations => relatedIntegrations.filter(ri => !(0, _fp.isEmpty)(ri.package));
exports.filterOutEmptyRelatedIntegrations = filterOutEmptyRelatedIntegrations;
const isRuleAction = (action, actionTypeRegistry) => !actionTypeRegistry.get(action.actionTypeId).isSystemActionType;
exports.isRuleAction = isRuleAction;
const formatActionsStepData = (actionsStepData, actionTypeRegistry) => {
  const {
    actions = [],
    responseActions,
    enabled,
    kibanaSiemAppUrl
  } = actionsStepData;
  return {
    actions: actions.map(action => isRuleAction(action, actionTypeRegistry) ? (0, _transform_actions.transformAlertToRuleAction)(action) : (0, _transform_actions.transformAlertToRuleSystemAction)(action)),
    response_actions: responseActions === null || responseActions === void 0 ? void 0 : responseActions.map(_transform_actions.transformAlertToRuleResponseAction),
    enabled,
    meta: {
      kibana_siem_app_url: kibanaSiemAppUrl
    }
  };
};

// Used to format form data in rule edit and
// create flows so "T" here would likely
// either be RuleCreateProps or Rule
exports.formatActionsStepData = formatActionsStepData;
const formatRule = (defineStepData, aboutStepData, scheduleData, actionsData, actionTypeRegistry, exceptionsList) => _deepmerge.default.all([formatDefineStepData(defineStepData), formatAboutStepData(aboutStepData, exceptionsList), formatScheduleStepData(scheduleData), formatActionsStepData(actionsData, actionTypeRegistry)]);
exports.formatRule = formatRule;
const formatPreviewRule = ({
  defineRuleData,
  aboutRuleData,
  scheduleRuleData,
  exceptionsList,
  actionTypeRegistry
}) => {
  const aboutStepData = {
    ...aboutRuleData,
    name: 'Preview Rule',
    description: 'Preview Rule'
  };
  return {
    ...formatRule(defineRuleData, aboutStepData, scheduleRuleData, _step_rule_actions.stepActionsDefaultValue, actionTypeRegistry, exceptionsList)
  };
};
exports.formatPreviewRule = formatPreviewRule;