"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistentThreatMatchState = usePersistentThreatMatchState;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _utils = require("../../../../../common/detection_engine/utils");
var _shared_imports = require("../../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Persists threat match form data when switching between threat match and the other rule types.
 */
function usePersistentThreatMatchState({
  form
}) {
  const lastThreatMatchState = (0, _react.useRef)();
  const [{
    ruleType,
    threatIndex: threatIndexPatterns,
    threatQueryBar,
    threatMapping
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['ruleType', 'threatIndex', 'threatQueryBar', 'threatMapping']
  });
  const previousRuleType = (0, _usePrevious.default)(ruleType);
  (0, _react.useEffect)(() => {
    if ((0, _utils.isThreatMatchRule)(ruleType) && !(0, _utils.isThreatMatchRule)(previousRuleType) && lastThreatMatchState.current) {
      form.updateFieldValues({
        threatIndex: lastThreatMatchState.current.threatIndexPatterns,
        threatQueryBar: lastThreatMatchState.current.threatQueryBar,
        threatMapping: lastThreatMatchState.current.threatMapping
      });
      return;
    }
    if ((0, _utils.isThreatMatchRule)(ruleType)) {
      lastThreatMatchState.current = {
        threatIndexPatterns,
        threatQueryBar,
        threatMapping
      };
    }
  }, [form, ruleType, previousRuleType, threatIndexPatterns, threatQueryBar, threatMapping]);
}