"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptimizedAccordion = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/rule_preview/optimized_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * component does not render children before it was opened
 * once children rendered for the first time, they won't be re-rendered on subsequent accordion toggling
 */
const OptimizedAccordionComponent = ({
  children,
  ...props
}) => {
  const [trigger, setTrigger] = (0, _react.useState)('closed');
  const [isRendered, setIsRendered] = (0, _react.useState)(false);
  const onToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    if (isOpen) {
      setIsRendered(true);
    }
    setTrigger(newState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({}, props, {
    forceState: trigger,
    onToggle: onToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }), isRendered || props.forceState === 'open' ? children : null);
};
const OptimizedAccordion = exports.OptimizedAccordion = /*#__PURE__*/_react.default.memo(OptimizedAccordionComponent);
OptimizedAccordion.displayName = 'OptimizedAccordion';