"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdEdit = ThresholdEdit;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _threshold_input = require("../../../rule_creation_ui/components/threshold_input");
var _field_configs = require("./field_configs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/threshold_edit/threshold_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ThresholdEdit({
  path,
  esFields
}) {
  const aggregatableFields = (0, _react.useMemo)(() => esFields.filter(field => field.aggregatable === true), [esFields]);
  const ThresholdInputChildren = (0, _react.useCallback)(({
    thresholdField,
    thresholdValue,
    thresholdCardinalityField,
    thresholdCardinalityValue
  }) => /*#__PURE__*/_react.default.createElement(_threshold_input.ThresholdInput, {
    browserFields: aggregatableFields,
    thresholdField: thresholdField,
    thresholdValue: thresholdValue,
    thresholdCardinalityField: thresholdCardinalityField,
    thresholdCardinalityValue: thresholdCardinalityValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), [aggregatableFields]);
  const cardinalityFieldConfig = (0, _react.useMemo)(() => (0, _field_configs.getCardinalityFieldConfig)(path), [path]);
  const cardinalityValueConfig = (0, _react.useMemo)(() => (0, _field_configs.getCardinalityValueConfig)(path), [path]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      thresholdField: {
        path: `${path}.field`,
        config: _field_configs.THRESHOLD_FIELD_CONFIG
      },
      thresholdValue: {
        path: `${path}.value`,
        config: _field_configs.THRESHOLD_VALUE_CONFIG
      },
      thresholdCardinalityField: {
        path: `${path}.cardinality.field`,
        config: cardinalityFieldConfig
      },
      thresholdCardinalityValue: {
        path: `${path}.cardinality.value`,
        config: cardinalityValueConfig
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, ThresholdInputChildren);
}