"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REQUIRED_FIELDS_LABEL = exports.REQUIRED_FIELDS_GENERAL_WARNING_TITLE = exports.REMOVE_REQUIRED_FIELD_BUTTON_ARIA_LABEL = exports.OPEN_HELP_POPOVER_ARIA_LABEL = exports.FIELD_TYPE_REQUIRED = exports.FIELD_TYPE_NOT_FOUND_WARNING = exports.FIELD_TYPE = exports.FIELD_NAME_USED_MORE_THAN_ONCE = exports.FIELD_NAME_REQUIRED = exports.FIELD_NAME_NOT_FOUND_WARNING = exports.FIELD_NAME = exports.ADD_REQUIRED_FIELD = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REQUIRED_FIELDS_LABEL = exports.REQUIRED_FIELDS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.requiredFieldsLabel', {
  defaultMessage: 'Required fields'
});
const FIELD_NAME = exports.FIELD_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.fieldNameLabel', {
  defaultMessage: 'Field name'
});
const FIELD_TYPE = exports.FIELD_TYPE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.fieldTypeLabel', {
  defaultMessage: 'Field type'
});
const OPEN_HELP_POPOVER_ARIA_LABEL = exports.OPEN_HELP_POPOVER_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.openHelpPopoverAriaLabel', {
  defaultMessage: 'Required fields help'
});
const REQUIRED_FIELDS_GENERAL_WARNING_TITLE = exports.REQUIRED_FIELDS_GENERAL_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.generalWarningTitle', {
  defaultMessage: `Some fields aren't found within the rule's specified index patterns.`
});
const REMOVE_REQUIRED_FIELD_BUTTON_ARIA_LABEL = exports.REMOVE_REQUIRED_FIELD_BUTTON_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.removeRequiredFieldButtonAriaLabel', {
  defaultMessage: 'Remove required field'
});
const ADD_REQUIRED_FIELD = exports.ADD_REQUIRED_FIELD = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.addRequiredFieldButtonLabel', {
  defaultMessage: 'Add required field'
});
const FIELD_NAME_NOT_FOUND_WARNING = name => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.fieldNameNotFoundWarning', {
  values: {
    name
  },
  defaultMessage: `Field "{name}" is not found within the rule's specified index patterns`
});
exports.FIELD_NAME_NOT_FOUND_WARNING = FIELD_NAME_NOT_FOUND_WARNING;
const FIELD_TYPE_NOT_FOUND_WARNING = (name, type) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.fieldTypeNotFoundWarning', {
  values: {
    name,
    type
  },
  defaultMessage: `Field "{name}" with type "{type}" is not found within the rule's specified index patterns`
});
exports.FIELD_TYPE_NOT_FOUND_WARNING = FIELD_TYPE_NOT_FOUND_WARNING;
const FIELD_NAME_REQUIRED = exports.FIELD_NAME_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.validation.fieldNameRequired', {
  defaultMessage: 'Field name is required'
});
const FIELD_TYPE_REQUIRED = exports.FIELD_TYPE_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.validation.fieldTypeRequired', {
  defaultMessage: 'Field type is required'
});
const FIELD_NAME_USED_MORE_THAN_ONCE = name => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.requiredFields.validation.fieldNameUsedMoreThanOnce', {
  values: {
    name
  },
  defaultMessage: 'Field name "{name}" is already used'
});
exports.FIELD_NAME_USED_MORE_THAN_ONCE = FIELD_NAME_USED_MORE_THAN_ONCE;