"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION_DEPENDENCY_REQUIRED = exports.VERSION_DEPENDENCY_INVALID = exports.REMOVE_RELATED_INTEGRATION_BUTTON_ARIA_LABEL = exports.RELATED_INTEGRATION_VERSION_DEPENDENCY_PLACEHOLDER = exports.RELATED_INTEGRATION_VERSION_DEPENDENCY_ARIA_LABEL = exports.RELATED_INTEGRATION_FIELDS_HELP_TEXT = exports.RELATED_INTEGRATION_ARIA_LABEL = exports.RELATED_INTEGRATIONS_LABEL = exports.RELATED_INTEGRATIONS_HELP_ARIA_LABEL = exports.INTEGRATION_VERSION = exports.INTEGRATION_NOT_INSTALLED = exports.INTEGRATION_INSTALLED_AND_ENABLED = exports.INTEGRATION_INSTALLED_AND_DISABLED = exports.INTEGRATION_ENABLED = exports.INTEGRATION_DISABLED = exports.ADD_INTEGRATION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RELATED_INTEGRATIONS_LABEL = exports.RELATED_INTEGRATIONS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.fieldRelatedIntegrationsLabel', {
  defaultMessage: 'Related integrations'
});
const RELATED_INTEGRATION_FIELDS_HELP_TEXT = exports.RELATED_INTEGRATION_FIELDS_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.helpText', {
  defaultMessage: 'Select an integration and correct a version constraint if necessary.'
});
const RELATED_INTEGRATION_ARIA_LABEL = exports.RELATED_INTEGRATION_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.relatedIntegrationAriaLabel', {
  defaultMessage: 'Integrations selector'
});
const RELATED_INTEGRATION_VERSION_DEPENDENCY_ARIA_LABEL = exports.RELATED_INTEGRATION_VERSION_DEPENDENCY_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.relatedIntegrationVersionDependencyAriaLabel', {
  defaultMessage: 'Related integration version constraint'
});
const RELATED_INTEGRATION_VERSION_DEPENDENCY_PLACEHOLDER = exports.RELATED_INTEGRATION_VERSION_DEPENDENCY_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.relatedIntegrationVersionDependencyPlaceholder', {
  defaultMessage: 'Enter version'
});
const REMOVE_RELATED_INTEGRATION_BUTTON_ARIA_LABEL = exports.REMOVE_RELATED_INTEGRATION_BUTTON_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.removeRelatedIntegrationButtonAriaLabel', {
  defaultMessage: 'Remove related integration'
});
const ADD_INTEGRATION = exports.ADD_INTEGRATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.addIntegration', {
  defaultMessage: 'Add integration'
});
const INTEGRATION_VERSION = exports.INTEGRATION_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.integrationVersion', {
  defaultMessage: 'Version'
});
const VERSION_DEPENDENCY_REQUIRED = exports.VERSION_DEPENDENCY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.validation.versionRequired', {
  defaultMessage: 'Version constraint must be specified. For example, ^1.2.3.'
});
const VERSION_DEPENDENCY_INVALID = exports.VERSION_DEPENDENCY_INVALID = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.validation.versionInvalid', {
  defaultMessage: 'Version constraint is invalid. Only tilde, caret or plain version supported e.g. ~1.2.3, ^1.2.3 or 1.2.3.'
});
const INTEGRATION_NOT_INSTALLED = exports.INTEGRATION_NOT_INSTALLED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.notInstalledText', {
  defaultMessage: 'Not installed'
});
const INTEGRATION_INSTALLED_AND_DISABLED = exports.INTEGRATION_INSTALLED_AND_DISABLED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.installedDisabledText', {
  defaultMessage: 'Installed: Disabled'
});
const INTEGRATION_INSTALLED_AND_ENABLED = exports.INTEGRATION_INSTALLED_AND_ENABLED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.installedEnabledText', {
  defaultMessage: 'Installed: Enabled'
});
const INTEGRATION_DISABLED = integrationTitle => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.integrationDisabledText', {
  defaultMessage: '{integrationTitle}: Disabled',
  values: {
    integrationTitle
  }
});
exports.INTEGRATION_DISABLED = INTEGRATION_DISABLED;
const INTEGRATION_ENABLED = integrationTitle => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.integrationEnabledText', {
  defaultMessage: '{integrationTitle}: Enabled',
  values: {
    integrationTitle
  }
});
exports.INTEGRATION_ENABLED = INTEGRATION_ENABLED;
const RELATED_INTEGRATIONS_HELP_ARIA_LABEL = exports.RELATED_INTEGRATIONS_HELP_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDescription.relatedIntegrations.helpAriaLabel', {
  defaultMessage: 'Related integrations help'
});