"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewManagerLogger = exports.DATA_VIEW_LOGGER_NAME = void 0;
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_VIEW_LOGGER_NAME = exports.DATA_VIEW_LOGGER_NAME = 'dataViewManager';
const useDataViewManagerLogger = (...childContextPaths) => {
  const services = (0, _kibana.useKibana)().services;
  childContextPaths.unshift(DATA_VIEW_LOGGER_NAME);
  return services.logger.get(...childContextPaths);
};
exports.useDataViewManagerLogger = useDataViewManagerLogger;