"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBoolean = exports.explainLackOfPermission = exports.canEditRuleWithActions = void 0;
var i18nActions = _interopRequireWildcard(require("../../../detection_engine/common/translations"));
var _helpers = require("../../../../common/machine_learning/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isBoolean = obj => typeof obj === 'boolean';
exports.isBoolean = isBoolean;
const canEditRuleWithActions = (rule, privileges) => {
  var _rule$actions;
  if (rule == null) {
    return true;
  }
  if (((_rule$actions = rule.actions) === null || _rule$actions === void 0 ? void 0 : _rule$actions.length) > 0 && isBoolean(privileges)) {
    return privileges;
  }
  return true;
};
exports.canEditRuleWithActions = canEditRuleWithActions;
const explainLackOfPermission = (rule, hasMlPermissions, hasReadActionsPrivileges, canEditRules) => {
  if (rule == null) {
    return undefined;
  } else if ((0, _helpers.isMlRule)(rule.type) && !hasMlPermissions) {
    return i18nActions.ML_RULES_DISABLED_MESSAGE;
  } else if (!canEditRuleWithActions(rule, hasReadActionsPrivileges)) {
    return i18nActions.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES;
  } else if (!canEditRules) {
    return i18nActions.LACK_OF_KIBANA_RULES_FEATURE_PRIVILEGES;
  } else {
    return undefined;
  }
};
exports.explainLackOfPermission = explainLackOfPermission;