"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cloneHttpFetchQuery = cloneHttpFetchQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function cloneHttpFetchQuery(query) {
  const clone = {};
  for (const [key, value] of Object.entries(query)) {
    if (Array.isArray(value)) {
      clone[key] = [...value];
    } else {
      // Array.isArray is not removing ImmutableArray from the union.
      clone[key] = value;
    }
  }
  return clone;
}