"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemMigrationsTelemetryEvents = exports.siemMigrationEventNames = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const siemMigrationEventNames = exports.siemMigrationEventNames = {
  [_types.SiemMigrationsRuleEventTypes.SetupConnectorSelected]: 'Connector Selected',
  [_types.SiemMigrationsDashboardEventTypes.SetupConnectorSelected]: 'Connector Selected',
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationOpenNew]: 'Open new rules migration',
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationOpenNew]: 'Open new dashboard migration',
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationCreated]: 'Create new rules migration',
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationCreated]: 'Create new dashboard migration',
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationDeleted]: 'Migration deleted',
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationDeleted]: 'Migration deleted',
  [_types.SiemMigrationsRuleEventTypes.SetupResourcesUploaded]: 'Upload rule resources',
  [_types.SiemMigrationsDashboardEventTypes.SetupResourcesUploaded]: 'Upload dashboard resources',
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationOpenResources]: 'Rules Open Resources',
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationOpenResources]: 'Dashboard Open Resources',
  [_types.SiemMigrationsRuleEventTypes.SetupQueryCopied]: 'Copy rules query',
  [_types.SiemMigrationsDashboardEventTypes.SetupQueryCopied]: 'Copy dashboard query',
  [_types.SiemMigrationsRuleEventTypes.SetupMacrosQueryCopied]: 'Copy macros query',
  [_types.SiemMigrationsDashboardEventTypes.SetupMacrosQueryCopied]: 'Copy macros query',
  [_types.SiemMigrationsRuleEventTypes.SetupLookupNameCopied]: 'Copy lookup name',
  [_types.SiemMigrationsDashboardEventTypes.SetupLookupNameCopied]: 'Copy lookup name',
  [_types.SiemMigrationsRuleEventTypes.StartMigration]: 'Start rule migration',
  [_types.SiemMigrationsDashboardEventTypes.StartMigration]: 'Start dashboard migration',
  [_types.SiemMigrationsRuleEventTypes.StopMigration]: 'Stop rule migration',
  [_types.SiemMigrationsDashboardEventTypes.StopMigration]: 'Stop dashboard migration',
  [_types.SiemMigrationsRuleEventTypes.TranslatedItemUpdate]: 'Update translated rule',
  [_types.SiemMigrationsDashboardEventTypes.TranslatedItemUpdate]: 'Update translated dashboard',
  [_types.SiemMigrationsRuleEventTypes.TranslatedItemInstall]: 'Install translated rule',
  [_types.SiemMigrationsDashboardEventTypes.TranslatedItemInstall]: 'Install translated dashboard',
  [_types.SiemMigrationsRuleEventTypes.TranslatedBulkInstall]: 'Bulk install translated rules',
  [_types.SiemMigrationsDashboardEventTypes.TranslatedBulkInstall]: 'Bulk install translated dashboards'
};
const baseResultActionSchema = {
  result: {
    type: 'keyword',
    _meta: {
      description: 'Indicates whether the action succeeded. Can be one of `success` or `failed`',
      optional: false
    }
  },
  errorMessage: {
    type: 'text',
    _meta: {
      description: 'The error message if action has failed',
      optional: true
    }
  }
};
const migrationIdSchema = {
  migrationId: {
    type: 'keyword',
    _meta: {
      description: 'SIEM migration ID',
      optional: false
    }
  }
};
const eventNameSchema = {
  eventName: {
    type: 'keyword',
    _meta: {
      description: 'The event name/description',
      optional: false
    }
  }
};
const vendorSchema = {
  vendor: {
    type: 'keyword',
    _meta: {
      description: 'Vendor of the migration',
      optional: true
    }
  }
};

// This type ensures that the event schemas are correctly typed according to the event type

const eventSchemas = {
  // Setup Events
  [_types.SiemMigrationsRuleEventTypes.SetupConnectorSelected]: {
    ...eventNameSchema,
    connectorType: {
      type: 'keyword',
      _meta: {
        description: 'Connector type',
        optional: false
      }
    },
    connectorId: {
      type: 'keyword',
      _meta: {
        description: 'Connector ID',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationOpenNew]: {
    ...eventNameSchema,
    isFirstMigration: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if this is the first migration',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationOpenResources]: {
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    missingResourcesCount: {
      type: 'integer',
      _meta: {
        description: 'Number of missing resources',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationCreated]: {
    ...baseResultActionSchema,
    ...eventNameSchema,
    ...vendorSchema,
    migrationId: {
      ...migrationIdSchema.migrationId,
      _meta: {
        ...migrationIdSchema.migrationId._meta,
        optional: true // Error case does not have the migration ID
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of rules uploaded',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.SetupMigrationDeleted]: {
    ...migrationIdSchema,
    ...baseResultActionSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsRuleEventTypes.SetupQueryCopied]: {
    ...eventNameSchema,
    ...vendorSchema,
    migrationId: {
      ...migrationIdSchema.migrationId,
      _meta: {
        ...migrationIdSchema.migrationId._meta,
        optional: true // Migration is not usually created yet when the query is copied
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.SetupMacrosQueryCopied]: {
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsRuleEventTypes.SetupLookupNameCopied]: {
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsRuleEventTypes.SetupResourcesUploaded]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    type: {
      type: 'keyword',
      _meta: {
        description: `Resource type, can be one of 'macro' or 'lookup'`,
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of resources uploaded',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.StartMigration]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    connectorId: {
      type: 'keyword',
      _meta: {
        description: 'Connector ID',
        optional: false
      }
    },
    skipPrebuiltRulesMatching: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if prebuilt rules should be matched',
        optional: false
      }
    },
    isRetry: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if this is a retry',
        optional: false
      }
    },
    retryFilter: {
      type: 'keyword',
      _meta: {
        description: 'Retry filter',
        optional: true
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.StopMigration]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  // Translated Rule Events

  [_types.SiemMigrationsRuleEventTypes.TranslatedItemUpdate]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    ruleMigrationId: {
      type: 'keyword',
      _meta: {
        description: 'Migration ID',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.TranslatedItemInstall]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...vendorSchema,
    ...eventNameSchema,
    ruleMigrationId: {
      type: 'keyword',
      _meta: {
        description: 'Migration ID',
        optional: false
      }
    },
    author: {
      type: 'keyword',
      _meta: {
        description: 'The source of the translated item. Can be one of elastic` or `custom`',
        optional: false
      }
    },
    enabled: {
      type: 'boolean',
      _meta: {
        description: 'Is installed item enabled',
        optional: false
      }
    },
    prebuiltRule: {
      _meta: {
        description: 'Matched elastic prebuilt rule details',
        optional: true
      },
      properties: {
        id: {
          type: 'keyword',
          _meta: {
            description: 'Matched elastic prebuilt rule ID',
            optional: false
          }
        },
        title: {
          type: 'keyword',
          _meta: {
            description: 'Matched elastic prebuilt rule title',
            optional: false
          }
        }
      }
    }
  },
  [_types.SiemMigrationsRuleEventTypes.TranslatedBulkInstall]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...vendorSchema,
    ...eventNameSchema,
    enabled: {
      type: 'boolean',
      _meta: {
        description: 'Are installed rules enabled',
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of rules to be installed',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupConnectorSelected]: {
    ...eventNameSchema,
    connectorType: {
      type: 'keyword',
      _meta: {
        description: 'Connector type',
        optional: false
      }
    },
    connectorId: {
      type: 'keyword',
      _meta: {
        description: 'Connector ID',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationOpenNew]: {
    ...eventNameSchema,
    isFirstMigration: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if this is the first migration',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationOpenResources]: {
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    missingResourcesCount: {
      type: 'integer',
      _meta: {
        description: 'Number of missing resources',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationCreated]: {
    ...baseResultActionSchema,
    ...eventNameSchema,
    ...vendorSchema,
    migrationId: {
      ...migrationIdSchema.migrationId,
      _meta: {
        ...migrationIdSchema.migrationId._meta,
        optional: true // Error case does not have the migration ID
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of dashboards uploaded',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupMigrationDeleted]: {
    ...migrationIdSchema,
    ...baseResultActionSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupQueryCopied]: {
    ...eventNameSchema,
    ...vendorSchema,
    migrationId: {
      ...migrationIdSchema.migrationId,
      _meta: {
        ...migrationIdSchema.migrationId._meta,
        optional: true // Migration is not usually created yet when the query is copied
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupMacrosQueryCopied]: {
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupLookupNameCopied]: {
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsDashboardEventTypes.SetupResourcesUploaded]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    type: {
      type: 'keyword',
      _meta: {
        description: `Resource type, can be one of 'macro' or 'lookup'`,
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of resources uploaded',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.StartMigration]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    connectorId: {
      type: 'keyword',
      _meta: {
        description: 'Connector ID',
        optional: false
      }
    },
    skipPrebuiltRulesMatching: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if prebuilt rules should be matched',
        optional: false
      }
    },
    isRetry: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if this is a retry',
        optional: false
      }
    },
    retryFilter: {
      type: 'keyword',
      _meta: {
        description: 'Retry filter',
        optional: true
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.StopMigration]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema
  },
  [_types.SiemMigrationsDashboardEventTypes.TranslatedItemUpdate]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...eventNameSchema,
    ...vendorSchema,
    ruleMigrationId: {
      type: 'keyword',
      _meta: {
        description: 'Migration ID',
        optional: false
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.TranslatedItemInstall]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...vendorSchema,
    ...eventNameSchema,
    ruleMigrationId: {
      type: 'keyword',
      _meta: {
        description: 'Migration ID',
        optional: false
      }
    },
    author: {
      type: 'keyword',
      _meta: {
        description: 'The source of the translated item. Can be one of elastic` or `custom`',
        optional: false
      }
    },
    enabled: {
      type: 'boolean',
      _meta: {
        description: 'Is installed item enabled',
        optional: false
      }
    },
    prebuiltRule: {
      _meta: {
        description: 'Matched elastic prebuilt rule details',
        optional: true
      },
      properties: {
        id: {
          type: 'keyword',
          _meta: {
            description: 'Matched elastic prebuilt rule ID',
            optional: false
          }
        },
        title: {
          type: 'keyword',
          _meta: {
            description: 'Matched elastic prebuilt rule title',
            optional: false
          }
        }
      }
    }
  },
  [_types.SiemMigrationsDashboardEventTypes.TranslatedBulkInstall]: {
    ...baseResultActionSchema,
    ...migrationIdSchema,
    ...vendorSchema,
    ...eventNameSchema,
    enabled: {
      type: 'boolean',
      _meta: {
        description: 'Are installed dashboards enabled',
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of dashboards to be installed',
        optional: false
      }
    }
  }
};
const siemMigrationsTelemetryEvents = exports.siemMigrationsTelemetryEvents = Object.entries(eventSchemas).map(([key, schema]) => ({
  eventType: key,
  schema
}));