"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aiValueReportTelemetryEvents = exports.aiValueReportExportInsightVerifiedEvent = exports.aiValueReportExportErrorEvent = exports.AIValueReportExportExecutionEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AIValueReportExportExecutionEvent = exports.AIValueReportExportExecutionEvent = {
  eventType: _types.AIValueReportEventTypes.AIValueReportExportExecution,
  schema: {}
};
const aiValueReportExportErrorEvent = exports.aiValueReportExportErrorEvent = {
  eventType: _types.AIValueReportEventTypes.AIValueReportExportError,
  schema: {
    errorMessage: {
      type: 'text',
      _meta: {
        description: 'The error message that occurs while exporting the AI Value Report',
        optional: false
      }
    },
    isExportMode: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if the error occurs in export mode',
        optional: false
      }
    }
  }
};
const aiValueReportExportInsightVerifiedEvent = exports.aiValueReportExportInsightVerifiedEvent = {
  eventType: _types.AIValueReportEventTypes.AIValueReportExportInsightVerified,
  schema: {
    shouldRegenerate: {
      type: 'boolean',
      _meta: {
        description: 'Flag indicating if the insight received as parameter in the export should be regenerated',
        optional: false
      }
    }
  }
};
const aiValueReportTelemetryEvents = exports.aiValueReportTelemetryEvents = [aiValueReportExportErrorEvent, AIValueReportExportExecutionEvent, aiValueReportExportInsightVerifiedEvent];