"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAgentTypeAndActionSupported = void 0;
var _is_response_action_supported = require("../../../../../common/endpoint/service/response_actions/is_response_action_supported");
var _experimental_features_service = require("../../../experimental_features_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if a given Agent type is supported (aka: is feature flag enabled) and optionally
 * also checks if a given response action is implemented for that agent type.
 */
const isAgentTypeAndActionSupported = (agentType, actionName, actionType = 'manual') => {
  const features = _experimental_features_service.ExperimentalFeaturesService.get();
  const isSentinelOneRunScriptEnabled = features.responseActionsSentinelOneRunScriptEnabled;
  const isAgentTypeSupported = agentType === 'endpoint' || agentType === 'sentinel_one' || agentType === 'crowdstrike' || agentType === 'microsoft_defender_endpoint';
  let isActionNameSupported = !actionName || (0, _is_response_action_supported.isActionSupportedByAgentType)(agentType, actionName, actionType);

  // if response action is supported, then do specific response action FF checks
  if (isAgentTypeSupported && isActionNameSupported && actionName) {
    switch (agentType) {
      case 'sentinel_one':
        if (actionName === 'runscript' && !isSentinelOneRunScriptEnabled) {
          isActionNameSupported = false;
        }
        break;
      case 'crowdstrike':
        // Placeholder for future individual response actions FF checks
        break;
    }
  }
  return Boolean(isAgentTypeSupported && isActionNameSupported);
};
exports.isAgentTypeAndActionSupported = isAgentTypeAndActionSupported;