"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateByRouterEventHandler = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides an event handler that can be used with (for example) `onClick` props to prevent the
 * event's default behaviour and instead navigate to a route via the Router
 *
 * @param routeTo
 * @param onClick
 */
const useNavigateByRouterEventHandler = (routeTo, onClick) => {
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(ev => {
    try {
      if (onClick) {
        onClick(ev);
      }
    } catch (error) {
      ev.preventDefault();
      throw error;
    }
    if (ev.defaultPrevented) {
      return;
    }
    if (ev.button !== 0) {
      return;
    }
    if (ev.currentTarget instanceof HTMLAnchorElement && ev.currentTarget.target !== '' && ev.currentTarget.target !== '_self') {
      return;
    }
    if (ev.metaKey || ev.altKey || ev.ctrlKey || ev.shiftKey) {
      return;
    }
    ev.preventDefault();
    if (Array.isArray(routeTo)) {
      history.push(...routeTo);
    } else if (typeof routeTo === 'string') {
      history.push(routeTo);
    } else {
      history.push(routeTo);
    }
  }, [history, onClick, routeTo]);
};
exports.useNavigateByRouterEventHandler = useNavigateByRouterEventHandler;