"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddableInspect = void 0;
var _react = require("react");
var _utils = require("./utils");
var _get_total_count_from_tables = require("./get_total_count_from_tables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEmbeddableInspect = onEmbeddableLoad => {
  const setInspectData = (0, _react.useCallback)((isLoading, adapters) => {
    var _adapters$requests;
    if (!onEmbeddableLoad) {
      return;
    }

    // adapters is undefined when the embeddable is not loaded yet
    // so both loading and !adapters are interdependent
    if (isLoading || !adapters) {
      onEmbeddableLoad === null || onEmbeddableLoad === void 0 ? void 0 : onEmbeddableLoad({
        requests: [],
        responses: [],
        isLoading: true
      });
      return;
    }
    const data = (0, _utils.getRequestsAndResponses)((_adapters$requests = adapters.requests) === null || _adapters$requests === void 0 ? void 0 : _adapters$requests.getRequests());
    const embeddableData = {
      requests: data.requests,
      responses: data.responses,
      isLoading: false
    };

    // during error response, tables.tables == {}
    // so we only add tables if they exist to normalize no data scenario
    //
    // additionally, we introduce a total count to the meta object
    // in the same structure as it's present in each individual table data
    if (adapters.tables && Object.keys(adapters.tables.tables).length > 0) {
      const {
        tables
      } = adapters.tables;
      embeddableData.tables = {
        tables,
        meta: {
          statistics: {
            totalCount: (0, _get_total_count_from_tables.getTotalCountFromTables)(tables)
          }
        }
      };
    }
    onEmbeddableLoad(embeddableData);
  }, [onEmbeddableLoad]);
  return {
    setInspectData
  };
};
exports.useEmbeddableInspect = useEmbeddableInspect;