"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensEmbeddable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../../../data_view_manager/constants");
var _actions = require("../../store/inputs/actions");
var _kibana = require("../../lib/kibana");
var _use_lens_attributes = require("./use_lens_attributes");
var _use_actions = require("./use_actions");
var _modal = require("../inspect/modal");
var _constants2 = require("../../store/inputs/constants");
var _actions2 = require("./actions");
var _use_embeddable_inspect = require("./use_embeddable_inspect");
var _use_visualization_response = require("./use_visualization_response");
var _use_inspect = require("../inspect/use_inspect");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/visualization_actions/lens_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DISABLED_ACTIONS = ['ACTION_CUSTOMIZE_PANEL'];
const getStyles = (width, height) => {
  return {
    lensComponentWrapper: (0, _react2.css)({
      height: height ? `${height}px` : 'auto',
      width: width !== null && width !== void 0 ? width : 'auto',
      '.expExpressionRenderer__expression': {
        padding: '2px 0 0 0 !important'
      },
      '.legacyMtrVis__container': {
        padding: 0
      }
    })
  };
};
const LensEmbeddableComponent = ({
  applyGlobalQueriesAndFilters = true,
  applyPageAndTabsFilters = true,
  extraActions,
  extraOptions,
  getLensAttributes,
  height: wrapperHeight,
  id,
  inputsModelId = _constants2.InputsModelId.global,
  inspectTitle,
  lensAttributes,
  onLoad,
  scopeId = _constants.PageScope.default,
  enableLegendActions = true,
  stackByField,
  timerange,
  width: wrapperWidth,
  withActions = _use_actions.DEFAULT_ACTIONS,
  disableOnClickFilter = false,
  casesAttachmentMetadata,
  signalIndexName,
  esql
}) => {
  var _attributes$state, _attributes$state$vis, _attributes$state4;
  const styles = (0, _react.useMemo)(() => getStyles(wrapperWidth, wrapperHeight), [wrapperWidth, wrapperHeight]);
  const lensComponentStyle = (0, _react.useMemo)(() => ({
    height: wrapperHeight !== null && wrapperHeight !== void 0 ? wrapperHeight : '100%',
    width: wrapperWidth !== null && wrapperWidth !== void 0 ? wrapperWidth : '100%'
  }), [wrapperHeight, wrapperWidth]);
  const {
    lens,
    data: {
      actions: {
        createFiltersFromValueClickAction
      }
    }
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    loading,
    searchSessionId,
    tables
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: id
  });
  const attributes = (0, _use_lens_attributes.useLensAttributes)({
    applyGlobalQueriesAndFilters,
    applyPageAndTabsFilters,
    extraOptions,
    getLensAttributes,
    lensAttributes,
    scopeId,
    stackByField,
    title: '',
    esql,
    signalIndexName
  });
  const preferredSeriesType = attributes === null || attributes === void 0 ? void 0 : (_attributes$state = attributes.state) === null || _attributes$state === void 0 ? void 0 : (_attributes$state$vis = _attributes$state.visualization) === null || _attributes$state$vis === void 0 ? void 0 : _attributes$state$vis.preferredSeriesType;
  const LensComponent = lens.EmbeddableComponent;
  const overrides = (0, _react.useMemo)(() => enableLegendActions ? undefined : {
    settings: {
      legendAction: 'ignore',
      onBrushEnd: 'ignore'
    }
  }, [enableLegendActions]);
  const {
    setInspectData
  } = (0, _use_embeddable_inspect.useEmbeddableInspect)(onLoad);
  const {
    additionalRequests,
    additionalResponses,
    handleClick: handleInspectClick,
    handleCloseModal,
    isButtonDisabled: isInspectButtonDisabled,
    isShowingModal,
    request,
    response
  } = (0, _use_inspect.useInspect)({
    inputId: inputsModelId,
    isDisabled: loading,
    multiple: tables != null && Object.keys(tables.tables).length > 1,
    queryId: id
  });
  const inspectActionProps = (0, _react.useMemo)(() => ({
    handleInspectClick,
    isInspectButtonDisabled
  }), [handleInspectClick, isInspectButtonDisabled]);
  const actions = (0, _use_actions.useActions)({
    attributes,
    extraActions,
    inspectActionProps,
    timeRange: timerange,
    withActions,
    lensMetadata: casesAttachmentMetadata
  });
  const updateDateRange = (0, _react.useCallback)(({
    range
  }) => {
    const [min, max] = range;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: inputsModelId,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch, inputsModelId]);
  const onFilterCallback = (0, _react.useCallback)(event => {
    if (disableOnClickFilter) {
      event.preventDefault();
      return;
    }
    const callback = async e => {
      if (!isClickTriggerEvent(e) || preferredSeriesType !== 'area') {
        e.preventDefault();
        return;
      }
      // Update timerange when clicking on a dot in an area chart
      const [{
        query
      }] = await createFiltersFromValueClickAction({
        data: e.data,
        negate: e.negate
      });
      const rangeFilter = query === null || query === void 0 ? void 0 : query.range['@timestamp'];
      if (rangeFilter !== null && rangeFilter !== void 0 && rangeFilter.gte && rangeFilter !== null && rangeFilter !== void 0 && rangeFilter.lt) {
        updateDateRange({
          range: [rangeFilter.gte, rangeFilter.lt]
        });
      }
    };
    return callback;
  }, [createFiltersFromValueClickAction, updateDateRange, preferredSeriesType, disableOnClickFilter]);
  const adHocDataViews = (0, _react.useMemo)(() => {
    var _attributes$state2, _attributes$state3;
    return (attributes === null || attributes === void 0 ? void 0 : (_attributes$state2 = attributes.state) === null || _attributes$state2 === void 0 ? void 0 : _attributes$state2.adHocDataViews) != null ? Object.values(attributes === null || attributes === void 0 ? void 0 : (_attributes$state3 = attributes.state) === null || _attributes$state3 === void 0 ? void 0 : _attributes$state3.adHocDataViews).reduce((acc, adHocDataView) => {
      if ((adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.name) != null) {
        acc.push(adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.name);
      }
      return acc;
    }, []) : null;
  }, [attributes === null || attributes === void 0 ? void 0 : (_attributes$state4 = attributes.state) === null || _attributes$state4 === void 0 ? void 0 : _attributes$state4.adHocDataViews]);
  if (!searchSessionId) {
    return null;
  }
  if (!attributes) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.lensEmbeddable.NoDataToDisplay.title",
        defaultMessage: "No data to display",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 17
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_actions2.VisualizationActions, {
      extraActions: extraActions,
      getLensAttributes: getLensAttributes,
      inputId: inputsModelId,
      isInspectButtonDisabled: true,
      lensAttributes: attributes,
      queryId: id,
      stackByField: stackByField,
      timerange: timerange,
      title: inspectTitle,
      withActions: withActions,
      casesAttachmentMetadata: casesAttachmentMetadata,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, attributes && searchSessionId && /*#__PURE__*/_react.default.createElement("div", {
    css: styles.lensComponentWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(LensComponent, {
    attributes: attributes,
    disabledActions: DISABLED_ACTIONS,
    extraActions: actions,
    id: id,
    onBrushEnd: updateDateRange,
    onFilter: onFilterCallback,
    onLoad: setInspectData,
    overrides: overrides,
    searchSessionId: searchSessionId,
    showInspector: false,
    style: lensComponentStyle,
    css: {
      minWidth: '100px'
    },
    syncCursor: false,
    syncTooltips: false,
    timeRange: timerange,
    viewMode: 'view',
    withDefaultActions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  })), isShowingModal && request != null && response != null && /*#__PURE__*/_react.default.createElement(_modal.ModalInspectQuery, {
    adHocDataViews: adHocDataViews,
    additionalRequests: additionalRequests,
    additionalResponses: additionalResponses,
    closeModal: handleCloseModal,
    "data-test-subj": "inspect-modal",
    inputId: inputsModelId,
    request: request,
    response: response,
    title: inspectTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }));
};
const isClickTriggerEvent = e => {
  return Array.isArray(e.data) && 'column' in e.data[0];
};
const LensEmbeddable = exports.LensEmbeddable = /*#__PURE__*/_react.default.memo(LensEmbeddableComponent);