"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.closingReasons = exports.BulkAlertClosingReason = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/alert_bulk_closing_reason.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const closingReasons = exports.closingReasons = [{
  label: i18n.CLOSING_REASON_CLOSE_WITHOUT_REASON,
  key: undefined
}, {
  label: i18n.CLOSING_REASON_DUPLICATE,
  key: _types.AlertClosingReasonValues.duplicate
}, {
  label: i18n.CLOSING_REASON_FALSE_POSITIVE,
  key: _types.AlertClosingReasonValues.false_positive
}, {
  label: i18n.CLOSING_REASON_TRUE_POSITIVE,
  key: _types.AlertClosingReasonValues.true_positive
}, {
  label: i18n.CLOSING_REASON_BENIGN_POSITIVE,
  key: _types.AlertClosingReasonValues.benign_positive
}, {
  label: i18n.CLOSING_REASON_OTHER,
  key: _types.AlertClosingReasonValues.other
}];
/**
 * Renders the list of available closing action for
 * the alerts and the confirm button
 */
const BulkAlertClosingReasonComponent = ({
  onSubmit
}) => {
  const [options, setOptions] = (0, _react.useState)(closingReasons);
  const selectedOption = (0, _react.useMemo)(() => options.find(option => option.checked), [options]);
  const onSubmitHandler = (0, _react.useCallback)(() => {
    if (!selectedOption) return;
    onSubmit(selectedOption.key);
  }, [onSubmit, selectedOption]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: updatedOptions => setOptions(updatedOptions),
    singleSelection: "always",
    height: options.length * 32,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, list => list), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: true,
    size: "s",
    disabled: !selectedOption,
    onClick: onSubmitHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, i18n.ALERT_CLOSING_REASON_BUTTON_MESSAGE));
};
const BulkAlertClosingReason = exports.BulkAlertClosingReason = /*#__PURE__*/(0, _react.memo)(BulkAlertClosingReasonComponent);