"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointResponseActionResults = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_get_action_details = require("../../../management/hooks/response_actions/use_get_action_details");
var _user_privileges = require("../user_privileges");
var _use_get_automated_action_list = require("../../../management/hooks/response_actions/use_get_automated_action_list");
var _action_log_expanded_tray = require("../../../management/components/endpoint_response_actions_list/components/action_log_expanded_tray");
var _translations = require("./translations");
var _response_actions_empty_prompt = require("./response_actions_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/response_actions/endpoint_action_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointResponseActionResults = ({
  action,
  ruleName
}) => {
  const {
    agent
  } = action;
  const {
    action_id: actionId,
    expiration
  } = action.EndpointActions;
  const {
    endpointPrivileges: {
      canAccessEndpointActionsLogManagement
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const [isLive, setIsLive] = (0, _react.useState)(true);
  const {
    data: expandedAction
  } = (0, _use_get_automated_action_list.useGetAutomatedActionResponseList)({
    actionId,
    expiration,
    agent
  }, {
    enabled: canAccessEndpointActionsLogManagement,
    action,
    isLive
  });
  (0, _react.useEffect)(() => {
    setIsLive(() => {
      var _expandedAction$error;
      if (!expandedAction) {
        return true;
      }
      return !((_expandedAction$error = expandedAction.errors) !== null && _expandedAction$error !== void 0 && _expandedAction$error.length) && expandedAction.status === 'pending';
    });
  }, [expandedAction]);
  const eventText = expandedAction ? getCommentText(expandedAction) : '';
  const hostName = (0, _react.useMemo)(
  // we want to get the first and only hostname
  () => expandedAction !== null && expandedAction !== void 0 && expandedAction.hosts ? Object.values(expandedAction.hosts)[0].name : '', [expandedAction === null || expandedAction === void 0 ? void 0 : expandedAction.hosts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: ruleName,
    timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: action['@timestamp'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 18
      }
    }),
    event: eventText,
    "data-test-subj": 'endpoint-results-comment',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, canAccessEndpointActionsLogManagement ? expandedAction ? /*#__PURE__*/_react.default.createElement(ResponseActionDetailsWorkaround, {
    actionId: expandedAction.id,
    "data-test-subj": `response-results-${hostName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_response_actions_empty_prompt.ResponseActionsEmptyPrompt, {
    type: "endpoint",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }));
};
exports.EndpointResponseActionResults = EndpointResponseActionResults;
const getCommentText = action => {
  var _action$errors;
  if ((_action$errors = action.errors) !== null && _action$errors !== void 0 && _action$errors.length) {
    return _translations.ENDPOINT_COMMANDS.failed(action.command);
  }
  if (action.status === 'pending') {
    return _translations.ENDPOINT_COMMANDS.pending(action.command);
  }
  if (action.status === 'successful') {
    return _translations.ENDPOINT_COMMANDS.executed(action.command);
  }
  return _translations.ENDPOINT_COMMANDS.tried(action.command);
};

// Tech Debt - see team internal issue #9822
// This is a workaround to fix the issue where the action details record is missing critical fields.
// Because Automated Response Actions started to use the same component used in the action history log
// we need to ensure that the action details records is actually complete - thus we make an API call here
// to retrieve it.
// This should all be removed once issue 9822 is addressed and we have a single common `<ResponseActionDetails>`
// component that should be used everywhere.
const ResponseActionDetailsWorkaround = /*#__PURE__*/(0, _react.memo)(({
  actionId,
  'data-test-subj': dataTestSubj
}) => {
  const {
    data: actionDetailsApiResult,
    isLoading
  } = (0, _use_get_action_details.useGetActionDetails)(actionId);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 12
      }
    });
  }
  if (actionDetailsApiResult !== null && actionDetailsApiResult !== void 0 && actionDetailsApiResult.data) {
    return /*#__PURE__*/_react.default.createElement(_action_log_expanded_tray.ActionsLogExpandedTray, {
      action: actionDetailsApiResult.data,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    });
  }
  return null;
});
ResponseActionDetailsWorkaround.displayName = 'ResponseActionDetailsWorkaround';